/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.security.filter;

import com.mulesoft.tools.migration.library.mule.steps.core.filter.AbstractFilterMigrator;
import com.mulesoft.tools.migration.library.mule.steps.validation.ValidationPomContribution;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Collections;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ByIpRangeCidrFilter
extends AbstractFilterMigrator {
    private static final String FILTERS_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/filters";
    private static final Namespace FILTERS_NAMESPACE = Namespace.getNamespace((String)"filters", (String)"http://www.mulesoft.org/schema/mule/filters");
    public static final String XPATH_SELECTOR = "//*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/filters' and local-name() = 'filter-by-ip-range-cidr']";

    @Override
    public String getDescription() {
        return "Update filter-by-ip-range-cidr filter to use the validations module.";
    }

    public ByIpRangeCidrFilter() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Collections.singletonList(FILTERS_NAMESPACE));
    }

    @Override
    public void execute(Element element, MigrationReport report) throws RuntimeException {
        ByIpRangeCidrFilter.addValidationNamespace(element.getDocument());
        ValidationPomContribution.addValidationDependency((PomModel)this.getApplicationModel().getPomModel().get());
        element.setName("is-whitelisted-ip");
        element.setNamespace(VALIDATION_NAMESPACE);
        element.setAttribute("ipAddress", "#[if (attributes.headers['X-Forwarded-For'] != null) trim((attributes.headers['X-Forwarded-For'] splitBy  ',')[0]) else attributes.remoteAddress]");
        String ipFilterListName = XmlDslUtils.getContainerElement((Element)element).getAttributeValue("name") + "_filter-by-ip-range-cidr";
        element.setAttribute("whiteList", ipFilterListName);
        Element ipFilterList = new Element("ip-filter-list", VALIDATION_NAMESPACE).setAttribute("name", ipFilterListName);
        Element ips = new Element("ips", VALIDATION_NAMESPACE);
        ipFilterList.addContent((Content)ips.addContent((Content)new Element("ip", VALIDATION_NAMESPACE).setAttribute("value", element.getAttributeValue("cidr"))));
        XmlDslUtils.addTopLevelElement((Element)ipFilterList, (Document)element.getDocument());
        element.removeAttribute("cidr");
        this.handleFilter(element);
    }
}

