/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.splitter;

import com.mulesoft.tools.migration.library.mule.steps.splitter.SplitterAggregatorInfo;
import com.mulesoft.tools.migration.library.mule.steps.splitter.SplitterAggregatorUtils;
import com.mulesoft.tools.migration.library.mule.steps.vm.AbstractVmEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.vm.VmConnectorPomContribution;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class AbstractSplitter
extends AbstractApplicationModelMigrationStep {
    private static final String OLD_AGGREGATOR_TIMEOUT_ATTRIBUTE = "timeout";
    private static final String OLD_AGGREGATOR_FAIL_ON_TIMEOUT_ATTRIBUTE = "failOnTimeout";
    private static final String OLD_AGGREGATOR_PROCESSED_GROUPS_OBJECT_STORE_REF_ATTRIBUTE = "processed-groups-object-store-ref";
    private static final String OLD_AGGREGATOR_EVENT_GROUPS_OBJECT_STORE_REF_ATTRIBUTE = "event-groups-object-store-ref";
    private static final String OLD_AGGREGATOR_PERSISTENT_STORES_ATTRIBUTE = "persistentStores";
    private static final String OLD_AGGREGATOR_STORE_PREFIX_ATTRIBUTE = "storePrefix";
    private static final String AGGREGATORS_NAMESPACE_PREFIX = "aggregators";
    private static final String AGGREGATORS_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/aggregators";
    static final Namespace AGGREGATORS_NAMESPACE = Namespace.getNamespace((String)"aggregators", (String)"http://www.mulesoft.org/schema/mule/aggregators");
    private static final Element SET_VARIABLE_TEMPLATE = new Element("set-variable", XmlDslUtils.CORE_NAMESPACE);
    private static final Element SET_PAYLOAD_TEMPLATE = new Element("set-payload", XmlDslUtils.CORE_NAMESPACE);
    private static final Element AGGREGATOR_TEMPLATE = new Element("group-based-aggregator", AGGREGATORS_NAMESPACE).setAttribute("evictionTime", "0");
    private static final Element AGGREGATOR_LISTENER_TEMPLATE = new Element("aggregator-listener", AGGREGATORS_NAMESPACE).setAttribute("includeTimedOutGroups", "true");
    private static final Element VM_QUEUE_TEMPLATE = new Element("queue", AbstractVmEndpoint.VM_NAMESPACE);
    private static final Element FOR_EACH_TEMPLATE_ELEMENT = new Element("foreach", XmlDslUtils.CORE_NAMESPACE);
    private static final String FOR_EACH_COLLECTION_ATTRIBUTE_KEY = "collection";
    private static final Element VM_CONSUME_TEMPLATE_ELEMENT = new Element("consume", AbstractVmEndpoint.VM_NAMESPACE);
    private static final Element VM_PUBLISH_TEMPLATE_ELEMENT = new Element("publish", AbstractVmEndpoint.VM_NAMESPACE);
    private static final Element CHOICE_TEMPLATE_ELEMENT = new Element("choice", XmlDslUtils.CORE_NAMESPACE);
    private static final Element WHEN_TEMPLATE_ELEMENT = new Element("when", XmlDslUtils.CORE_NAMESPACE);

    protected abstract String getMatchingAggregatorName();

    protected Optional<String> getForEachCollectionAttribute(Element splitterElement) {
        return Optional.empty();
    }

    public void execute(Element splitter, MigrationReport report) throws RuntimeException {
        SplitterAggregatorInfo splitterAggregatorInfo = new SplitterAggregatorInfo(splitter, this.getApplicationModel());
        LinkedList<ReportEntry> reports = new LinkedList<ReportEntry>();
        Element forEachElement = null;
        this.registerNeverEnableCorrelationReport(splitter, reports);
        List<Element> elementsBetweenSplitterAndAggregator = this.collectUntilAggregator(splitter);
        Element aggregatorElement = null;
        if (!elementsBetweenSplitterAndAggregator.isEmpty() && this.foundMatchingAggregator(elementsBetweenSplitterAndAggregator.get(elementsBetweenSplitterAndAggregator.size() - 1))) {
            aggregatorElement = elementsBetweenSplitterAndAggregator.remove(elementsBetweenSplitterAndAggregator.size() - 1);
            SplitterAggregatorUtils.setAggregatorAsProcessed(aggregatorElement);
        }
        if (!this.isCustomAggregator(aggregatorElement)) {
            if (aggregatorElement == null) {
                this.registerNoAggregatorReport(splitter, reports);
            } else {
                aggregatorElement.detach();
            }
            Map<String, String> oldAggregatorAttributes = this.getOldAggregatorAttributes(aggregatorElement);
            forEachElement = this.wrapWithForEachAndAggregator(splitterAggregatorInfo, oldAggregatorAttributes, elementsBetweenSplitterAndAggregator);
            this.replaceInDocument(splitter, forEachElement, splitterAggregatorInfo, oldAggregatorAttributes);
            this.reportOldAggregatorAttributes(reports, oldAggregatorAttributes, aggregatorElement, forEachElement.getChild(AGGREGATOR_TEMPLATE.getName(), AGGREGATORS_NAMESPACE));
        } else {
            this.reportCustomAggregator(aggregatorElement, report);
        }
        this.writeRegisteredReports(forEachElement, reports, report);
    }

    private void replaceInDocument(Element splitterElement, Element forEachAggregatorElement, SplitterAggregatorInfo splitterAggregatorInfo, Map<String, String> oldAggregatorAttributes) {
        XmlDslUtils.addElementBefore((Element)this.getSetPayloadSizeVariableElement(splitterAggregatorInfo), (Element)splitterElement);
        if (oldAggregatorAttributes.containsKey(OLD_AGGREGATOR_TIMEOUT_ATTRIBUTE) && Long.parseLong(oldAggregatorAttributes.get(OLD_AGGREGATOR_TIMEOUT_ATTRIBUTE)) > 0L) {
            XmlDslUtils.addElementBefore((Element)this.getAggregationCompleteVariableElement(splitterAggregatorInfo, false), (Element)splitterElement);
            this.addVmQueue(splitterAggregatorInfo);
            this.setAggregatorListenerFlowContent(XmlDslUtils.addNewFlowAfter((String)splitterAggregatorInfo.getAggregatorListenerFlowName(), (Element)XmlDslUtils.getContainerElement((Element)splitterElement)), splitterAggregatorInfo);
            if (!oldAggregatorAttributes.containsKey(OLD_AGGREGATOR_FAIL_ON_TIMEOUT_ATTRIBUTE) || "true".equals(oldAggregatorAttributes.get(OLD_AGGREGATOR_FAIL_ON_TIMEOUT_ATTRIBUTE))) {
                XmlDslUtils.addElementAfter((Element)this.getFailOnTimeoutChoiceElement(splitterAggregatorInfo), (Element)splitterElement);
            }
            XmlDslUtils.addElementAfter((Element)this.getVmConsumeElement(splitterAggregatorInfo), (Element)splitterElement);
        } else {
            XmlDslUtils.addElementAfter((Element)this.getSetAggregationPayloadElement(splitterAggregatorInfo), (Element)splitterElement);
        }
        XmlDslUtils.addElementBefore((Element)forEachAggregatorElement, (Element)splitterElement);
        splitterElement.detach();
    }

    private Element wrapWithForEachAndAggregator(SplitterAggregatorInfo splitterAggregatorInfo, Map<String, String> oldAggregatorAttributes, List<Element> elements) {
        elements.forEach(Element::detach);
        Element forEachElement = FOR_EACH_TEMPLATE_ELEMENT.clone();
        forEachElement.addContent(elements);
        forEachElement.addContent((Content)this.getAggregatorElement(splitterAggregatorInfo, oldAggregatorAttributes));
        this.getForEachCollectionAttribute(splitterAggregatorInfo.getSplitterElement()).ifPresent(e -> forEachElement.setAttribute(FOR_EACH_COLLECTION_ATTRIBUTE_KEY, e));
        return forEachElement;
    }

    protected List<Element> collectUntilAggregator(Element splitter) {
        List splitterAndSiblings = splitter.getParentElement().getChildren();
        LinkedList<Element> elementsBetweenSplitterAndAggregator = new LinkedList<Element>();
        boolean shouldAdd = false;
        for (Element element : splitterAndSiblings) {
            if (element.equals((Object)splitter)) {
                shouldAdd = true;
                continue;
            }
            if (!shouldAdd) continue;
            elementsBetweenSplitterAndAggregator.add(element);
            if (!this.foundMatchingAggregator(element)) continue;
            break;
        }
        return elementsBetweenSplitterAndAggregator;
    }

    protected Optional<Element> getMatchingAggregatorElement(Element splitter) {
        List<Element> elementsUntilAggregator = this.collectUntilAggregator(splitter);
        if (!elementsUntilAggregator.isEmpty() && this.foundMatchingAggregator(elementsUntilAggregator.get(elementsUntilAggregator.size() - 1))) {
            return Optional.of(elementsUntilAggregator.get(elementsUntilAggregator.size() - 1));
        }
        return Optional.empty();
    }

    private boolean foundMatchingAggregator(Element aggregator) {
        return this.isCustomAggregator(aggregator) || this.getMatchingAggregatorName().equals(aggregator.getName());
    }

    private boolean isCustomAggregator(Element element) {
        return element != null && "custom-aggregator".equals(element.getName()) && XmlDslUtils.CORE_NAMESPACE.equals((Object)element.getNamespace());
    }

    private void reportOldAggregatorAttributes(List<ReportEntry> reports, Map<String, String> oldAggregatorAttributes, Element oldAggregator, Element newAggregator) {
        if (oldAggregatorAttributes.containsKey(OLD_AGGREGATOR_PROCESSED_GROUPS_OBJECT_STORE_REF_ATTRIBUTE)) {
            reports.add(new ReportEntry("aggregator.processedGroupsObjectStore", oldAggregator, newAggregator));
        }
        if (oldAggregatorAttributes.containsKey(OLD_AGGREGATOR_EVENT_GROUPS_OBJECT_STORE_REF_ATTRIBUTE)) {
            reports.add(new ReportEntry("aggregator.eventGroupsObjectStore", oldAggregator, newAggregator));
        }
        if (oldAggregatorAttributes.containsKey(OLD_AGGREGATOR_PERSISTENT_STORES_ATTRIBUTE)) {
            reports.add(new ReportEntry("aggregator.persistentStores", oldAggregator, newAggregator));
        }
        if (oldAggregatorAttributes.containsKey(OLD_AGGREGATOR_STORE_PREFIX_ATTRIBUTE)) {
            reports.add(new ReportEntry("aggregator.storePrefix", oldAggregator, newAggregator));
        }
    }

    private void reportCustomAggregator(Element aggregator, MigrationReport report) {
        report.report("aggregator.custom", aggregator, aggregator, new String[0]);
    }

    private void registerNoAggregatorReport(Element splitter, List<ReportEntry> reports) {
        reports.add(new ReportEntry("aggregator.missing", splitter));
    }

    private void registerNeverEnableCorrelationReport(Element splitter, List<ReportEntry> reports) {
        String enableCorrelation = splitter.getAttributeValue("enableCorrelation");
        if ("NEVER".equals(enableCorrelation)) {
            reports.add(new ReportEntry("splitter.neverCorrelationAttribute", splitter));
        }
    }

    private void writeRegisteredReports(Element forEachElement, List<ReportEntry> reports, MigrationReport migrationReport) {
        reports.forEach(r -> {
            Element reportOn = ((ReportEntry)r).reportOn.orElse(forEachElement);
            Element reportAbout = ((ReportEntry)r).reportAbout;
            String reportKey = ((ReportEntry)r).reportKey;
            migrationReport.report(reportKey, reportAbout, reportOn, new String[0]);
        });
    }

    private Element getAggregatorElement(SplitterAggregatorInfo splitterAggregatorInfo, Map<String, String> oldAggregatorAttributes) {
        Element aggregationCompleteRoute = new Element("aggregation-complete", AGGREGATORS_NAMESPACE);
        Element newAggregator = AGGREGATOR_TEMPLATE.clone().setAttribute("name", splitterAggregatorInfo.getAggregatorName()).setAttribute("groupSize", "#[vars.'" + splitterAggregatorInfo.getGroupSizeVariableName() + "']").addContent((Content)aggregationCompleteRoute);
        if (oldAggregatorAttributes.containsKey(OLD_AGGREGATOR_TIMEOUT_ATTRIBUTE)) {
            String timeout = oldAggregatorAttributes.get(OLD_AGGREGATOR_TIMEOUT_ATTRIBUTE);
            newAggregator.setAttribute(OLD_AGGREGATOR_TIMEOUT_ATTRIBUTE, timeout);
            newAggregator.setAttribute("timeoutUnit", "MILLISECONDS");
            aggregationCompleteRoute.getContent().add(0, this.getAggregationCompleteVariableElement(splitterAggregatorInfo, true));
        } else {
            aggregationCompleteRoute.getContent().add(0, this.getAggregationVariableElement(splitterAggregatorInfo));
        }
        if (oldAggregatorAttributes.containsKey(OLD_AGGREGATOR_EVENT_GROUPS_OBJECT_STORE_REF_ATTRIBUTE)) {
            newAggregator.setAttribute("objectStore", oldAggregatorAttributes.get(OLD_AGGREGATOR_EVENT_GROUPS_OBJECT_STORE_REF_ATTRIBUTE));
        }
        return newAggregator;
    }

    private Element setAggregatorListenerFlowContent(Element flow, SplitterAggregatorInfo splitterAggregatorInfo) {
        return flow.addContent((Content)AGGREGATOR_LISTENER_TEMPLATE.clone().setAttribute("aggregatorName", splitterAggregatorInfo.getAggregatorName())).addContent((Content)this.getVmPublishElement(splitterAggregatorInfo));
    }

    private Element getSetPayloadSizeVariableElement(SplitterAggregatorInfo splitterAggregatorInfo) {
        return SET_VARIABLE_TEMPLATE.clone().setAttribute("variableName", splitterAggregatorInfo.getGroupSizeVariableName()).setAttribute("value", "#[sizeOf(payload)]");
    }

    private Element getAggregationCompleteVariableElement(SplitterAggregatorInfo splitterAggregatorInfo, boolean value) {
        return SET_VARIABLE_TEMPLATE.clone().setAttribute("variableName", splitterAggregatorInfo.getAggregationCompleteVariableName()).setAttribute("value", value ? "#[true]" : "#[false]");
    }

    private Element getAggregationVariableElement(SplitterAggregatorInfo splitterAggregatorInfo) {
        return SET_VARIABLE_TEMPLATE.clone().setAttribute("variableName", splitterAggregatorInfo.getAggregationVariableName()).setAttribute("value", "#[payload]");
    }

    private Element getSetAggregationPayloadElement(SplitterAggregatorInfo splitterAggregatorInfo) {
        return SET_PAYLOAD_TEMPLATE.clone().setAttribute("value", "#[vars.'" + splitterAggregatorInfo.getAggregationVariableName() + "']");
    }

    private Element getVmConsumeElement(SplitterAggregatorInfo splitterAggregatorInfo) {
        return VM_CONSUME_TEMPLATE_ELEMENT.clone().setAttribute("config-ref", splitterAggregatorInfo.getVmConfigName()).setAttribute("queueName", splitterAggregatorInfo.getVmQueueName());
    }

    private Element getFailOnTimeoutChoiceElement(SplitterAggregatorInfo splitterAggregatorInfo) {
        return CHOICE_TEMPLATE_ELEMENT.clone().setContent((Content)WHEN_TEMPLATE_ELEMENT.clone().setAttribute("expression", splitterAggregatorInfo.getAggregationCompleteExpression()));
    }

    private Element getVmPublishElement(SplitterAggregatorInfo splitterAggregatorInfo) {
        return VM_PUBLISH_TEMPLATE_ELEMENT.clone().setAttribute("config-ref", splitterAggregatorInfo.getVmConfigName()).setAttribute("queueName", splitterAggregatorInfo.getVmQueueName());
    }

    private void addVmQueue(SplitterAggregatorInfo splitterAggregatorInfo) {
        Element vmConfig = AbstractVmEndpoint.migrateVmConfig(splitterAggregatorInfo.getSplitterElement(), Optional.empty(), splitterAggregatorInfo.getVmConfigName(), this.getApplicationModel());
        Element queues = vmConfig.getChild("queues", AbstractVmEndpoint.VM_NAMESPACE);
        queues.addContent((Content)VM_QUEUE_TEMPLATE.clone().setAttribute("queueName", splitterAggregatorInfo.getVmQueueName()));
        this.getApplicationModel().addNameSpace(AbstractVmEndpoint.VM_NAMESPACE.getPrefix(), AbstractVmEndpoint.VM_NAMESPACE.getURI(), "http://www.mulesoft.org/schema/mule/vm/current/mule-vm.xsd");
        this.getApplicationModel().getPomModel().ifPresent(VmConnectorPomContribution::addVMDependency);
    }

    private Map<String, String> getOldAggregatorAttributes(Element aggregatorElement) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (aggregatorElement != null) {
            this.addAttributeToMap(aggregatorElement, OLD_AGGREGATOR_TIMEOUT_ATTRIBUTE, attributes, null);
            this.addAttributeToMap(aggregatorElement, OLD_AGGREGATOR_FAIL_ON_TIMEOUT_ATTRIBUTE, attributes, "true");
            this.addAttributeToMap(aggregatorElement, OLD_AGGREGATOR_PROCESSED_GROUPS_OBJECT_STORE_REF_ATTRIBUTE, attributes, null);
            this.addAttributeToMap(aggregatorElement, OLD_AGGREGATOR_EVENT_GROUPS_OBJECT_STORE_REF_ATTRIBUTE, attributes, null);
            this.addAttributeToMap(aggregatorElement, OLD_AGGREGATOR_PERSISTENT_STORES_ATTRIBUTE, attributes, null);
            this.addAttributeToMap(aggregatorElement, OLD_AGGREGATOR_STORE_PREFIX_ATTRIBUTE, attributes, null);
        }
        return attributes;
    }

    private void addAttributeToMap(Element element, String attributeKey, Map<String, String> attributes, String defaultValue) {
        if (defaultValue != null) {
            attributes.put(attributeKey, element.getAttributeValue(attributeKey, defaultValue));
        } else {
            String value = element.getAttributeValue(attributeKey);
            if (value != null) {
                attributes.put(attributeKey, value);
            }
        }
    }

    private static class ReportEntry {
        private Optional<Element> reportOn;
        private Element reportAbout;
        private String reportKey;

        private ReportEntry(String reportKey, Element reportAbout) {
            this.reportKey = reportKey;
            this.reportAbout = reportAbout;
            this.reportOn = Optional.empty();
        }

        private ReportEntry(String reportKey, Element reportAbout, Element reportOn) {
            this(reportKey, reportAbout);
            this.reportOn = Optional.of(reportOn);
        }
    }
}

