/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.spring;

import com.mulesoft.tools.migration.library.tools.PluginsVersions;
import com.mulesoft.tools.migration.project.model.pom.Dependency;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.project.model.pom.PomModelUtils;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.category.PomContribution;

public class SpringPomContribution
implements PomContribution {
    private static final String SPRING_VERSION = "4.3.17.RELEASE";
    private static final String SPRING_SECURITY_VERSION = "4.2.6.RELEASE";

    public String getDescription() {
        return "Add Spring Module dependency.";
    }

    public void execute(PomModel object, MigrationReport report) throws RuntimeException {
        object.addDependency(new Dependency.DependencyBuilder().withGroupId("org.mule.modules").withArtifactId("mule-spring-module").withVersion(PluginsVersions.targetVersion("mule-spring-module")).withClassifier("mule-plugin").build());
        Dependency springCore = new Dependency.DependencyBuilder().withGroupId("org.springframework").withArtifactId("spring-core").withVersion(SPRING_VERSION).build();
        object.addDependency(springCore);
        Dependency springBeans = new Dependency.DependencyBuilder().withGroupId("org.springframework").withArtifactId("spring-beans").withVersion(SPRING_VERSION).build();
        object.addDependency(springBeans);
        Dependency springContext = new Dependency.DependencyBuilder().withGroupId("org.springframework").withArtifactId("spring-context").withVersion(SPRING_VERSION).build();
        object.addDependency(springContext);
        Dependency springAop = new Dependency.DependencyBuilder().withGroupId("org.springframework").withArtifactId("spring-aop").withVersion(SPRING_VERSION).build();
        object.addDependency(springAop);
        Dependency springSecurityCore = new Dependency.DependencyBuilder().withGroupId("org.springframework.security").withArtifactId("spring-security-core").withVersion(SPRING_SECURITY_VERSION).build();
        object.addDependency(springSecurityCore);
        Dependency springSecurityConfig = new Dependency.DependencyBuilder().withGroupId("org.springframework.security").withArtifactId("spring-security-config").withVersion(SPRING_SECURITY_VERSION).build();
        object.addDependency(springSecurityConfig);
        PomModelUtils.addSharedLibs((PomModel)object, (Dependency[])new Dependency[]{springCore, springBeans, springContext, springAop, springSecurityCore, springSecurityConfig});
    }
}

