/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.munit.steps;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.exception.MigrationStepException;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class MUnitTest
extends AbstractApplicationModelMigrationStep {
    private static final String MUNIT_TOOLS_PREFIX = "munit-tools";
    private static final String MUNIT_TOOLS_URI = "http://www.mulesoft.org/schema/mule/munit-tools";
    private static final Namespace MUNIT_TOOLS_NS = Namespace.getNamespace((String)"munit-tools", (String)"http://www.mulesoft.org/schema/mule/munit-tools");
    private static final String MUNIT_NS_PREFIX = "munit";
    private static final String MUNIT_NS_URI = "http://www.mulesoft.org/schema/mule/munit";
    private static final Namespace MUNIT_NS = Namespace.getNamespace((String)"munit", (String)"http://www.mulesoft.org/schema/mule/munit");
    private static String[] sections = new String[]{"munit:behavior", "munit:execution", "munit:validation"};
    private static final String XPATH_SELECTOR = XmlDslUtils.getXPathSelector((String)"http://www.mulesoft.org/schema/mule/munit", (String)"test", (boolean)true);

    public String getDescription() {
        return "Migrate MUnit test structure";
    }

    public MUnitTest() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{MUNIT_NS, MUNIT_TOOLS_NS}));
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        try {
            element.setAttribute("name", element.getAttributeValue("name").replaceAll("/", "\\\\").replaceAll("\\[|\\{", "(").replaceAll("\\]|\\}", ")").replaceAll("#", "_"));
            List childNodes = element.getChildren();
            this.createBehaviorSection(childNodes, element);
            this.createExecutionSection(childNodes, element);
            this.createValidationSection(childNodes, element);
        }
        catch (Exception e) {
            throw new MigrationStepException("Fail to apply step. " + e.getMessage());
        }
    }

    public void createBehaviorSection(List<Element> nodes, Element parent) {
        ArrayList<Element> behaviorNodes = new ArrayList<Element>();
        for (int pos = 0; !(nodes.size() <= pos || nodes.get(pos).getQualifiedName().equals("flow-ref") || nodes.get(pos).getQualifiedName().equals("munit-tools:assert-that") || ArrayUtils.contains((Object[])sections, (Object)nodes.get(pos).getQualifiedName())); ++pos) {
            behaviorNodes.add(nodes.get(pos));
        }
        this.createChildWithElements("behavior", behaviorNodes, parent);
    }

    public void createExecutionSection(List<Element> nodes, Element parent) {
        ArrayList<Element> behaviorNodes = new ArrayList<Element>();
        for (int pos = 0; nodes.size() > pos && !nodes.get(pos).getQualifiedName().equals("munit-tools:assert-that") && !ArrayUtils.contains((Object[])sections, (Object)nodes.get(pos).getQualifiedName()); ++pos) {
            behaviorNodes.add(nodes.get(pos));
        }
        this.createChildWithElements("execution", behaviorNodes, parent);
    }

    public void createValidationSection(List<Element> nodes, Element parent) {
        ArrayList<Element> behaviorNodes = new ArrayList<Element>();
        for (int pos = 0; nodes.size() > pos && !ArrayUtils.contains((Object[])sections, (Object)nodes.get(pos).getQualifiedName()); ++pos) {
            behaviorNodes.add(nodes.get(pos));
        }
        this.createChildWithElements("validation", behaviorNodes, parent);
    }

    private void createChildWithElements(String childName, List<Element> elements, Element parent) {
        if (elements.size() > 0) {
            elements.forEach(arg_0 -> ((Element)parent).removeContent(arg_0));
            Element section = new Element(childName);
            section.setNamespace(parent.getNamespace());
            section.addContent(elements);
            parent.addContent((Content)section);
        }
    }
}

