/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.soapkit.steps;

import com.mulesoft.tools.migration.library.soapkit.helpers.DocumentHelper;
import com.mulesoft.tools.migration.library.soapkit.steps.AbstractSoapkitMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.Arrays;
import org.jdom2.Element;

public class SoapkitRouter
extends AbstractSoapkitMigrationStep {
    private static final String XPATH_SELECTOR = "//*[local-name()='router' and namespace-uri()='http://www.mulesoft.org/schema/mule/apikit-soap']";

    public String getDescription() {
        return "Update APIkit for SOAP router";
    }

    public SoapkitRouter() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Arrays.asList(SOAPKIT_NAMESPACE));
    }

    public void execute(Element element, MigrationReport report) {
        DocumentHelper.replaceSlashesByBackSlashes(element, "config-ref");
        DocumentHelper.addElement(element, "message", "#[payload]");
        DocumentHelper.addElement(element, "attributes", this.getAttributesMapping());
    }

    private String getAttributesMapping() {
        return "#[%dw 2.0\noutput application/java\n---\n{\n   headers: attributes.headers,\n   method: attributes.method,\n   queryString: attributes.queryString\n}]";
    }
}

