/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.soapkit.steps;

import com.mulesoft.tools.migration.library.soapkit.helpers.DataWeaveHelper;
import com.mulesoft.tools.migration.library.soapkit.helpers.DocumentHelper;
import com.mulesoft.tools.migration.library.soapkit.steps.AbstractSoapkitMigrationStep;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public class SoapkitRouterConfig
extends AbstractSoapkitMigrationStep {
    private static final String XPATH_SELECTOR = "//*[local-name()='config' and namespace-uri()='http://www.mulesoft.org/schema/mule/apikit-soap']";
    private static final String EE_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/ee/core";
    private static final String EE_NAMESPACE_SCHEMA = "http://www.mulesoft.org/schema/mule/ee/core/current/mule-ee.xsd";
    private static final String EE_NAMESPACE_NAME = "ee";
    private static final Namespace EE_NAMESPACE = Namespace.getNamespace((String)"ee", (String)"http://www.mulesoft.org/schema/mule/ee/core");
    private static final String PAYLOAD_MAPPING_SCRIPT = "%dw 2.0\noutput application/java\nimport migration::Soapkit\n---\n{\n  body: Soapkit::soapBody(payload),\n  headers: Soapkit::soapHeaders(vars),\n  attachments: Soapkit::soapAttachments(vars)\n}";

    public String getDescription() {
        return "Update APIkit for SOAP config";
    }

    public SoapkitRouterConfig() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Arrays.asList(SOAPKIT_NAMESPACE));
    }

    public void execute(Element element, MigrationReport report) {
        SoapkitRouterConfig.soapkitLib(this.getApplicationModel());
        String originalConfigName = element.getAttributeValue("name");
        if (originalConfigName != null) {
            String migratedConfigName = this.migrateConfigName(originalConfigName);
            this.migrateConfigNameInRouter(element, originalConfigName, migratedConfigName);
            this.migrateConfigNameInFlows(element, originalConfigName, migratedConfigName);
            DocumentHelper.replaceAttributeValue(element, "name", value -> migratedConfigName);
        }
        DocumentHelper.renameAttribute(element, "inboundValidationMessage", "inboundValidationEnabled");
        DocumentHelper.renameAttribute(element, "wsdlUrl", "wsdlLocation");
        DocumentHelper.renameAttribute(element, "serviceName", "service");
        DocumentHelper.renameAttribute(element, "portName", "port");
    }

    private void migrateConfigNameInFlows(Element element, String originalConfigName, String migratedConfigName) {
        this.getElementByXpath(element.getDocument(), this.getSoapkitFlowXPathSelector(originalConfigName)).forEach(flow -> {
            this.replaceConfigNameInAttribute((Element)flow, "name", originalConfigName, "\\" + migratedConfigName);
            this.addPayloadMapping((Element)flow);
        });
    }

    private void migrateConfigNameInRouter(Element element, String originalConfigName, String migratedConfigName) {
        this.getElementByXpath(element.getDocument(), this.getSoapkitRouterXPathSelector(originalConfigName)).forEach(router -> this.replaceConfigNameInAttribute((Element)router, "config-ref", originalConfigName, migratedConfigName));
    }

    private void replaceConfigNameInAttribute(Element element, String attributeName, String originalConfigName, String migratedConfigName) {
        String nameWithInvertedSlashes = originalConfigName.replaceAll("/", "\\\\");
        DocumentHelper.replaceAttributeValue(element, attributeName, value -> {
            if (value.contains(originalConfigName) || originalConfigName.equals(nameWithInvertedSlashes)) {
                return value.replace(originalConfigName, migratedConfigName);
            }
            return value.replace(nameWithInvertedSlashes, migratedConfigName);
        });
    }

    private String migrateConfigName(String value) {
        String result = value.trim();
        return (result = result.replaceAll("/", "-").replaceAll("\\\\", "-")).startsWith("-") ? result.substring(1) : result;
    }

    private String getSoapkitFlowXPathSelector(String originalConfigName) {
        String nameWithInvertedSlashes = originalConfigName.replaceAll("/", "\\\\");
        return "//*[local-name()='flow' and ( ends-with(@name, '" + originalConfigName + "') or ends-with(@name, '" + nameWithInvertedSlashes + "') )]";
    }

    private String getSoapkitRouterXPathSelector(String originalConfigName) {
        String nameWithInvertedSlashes = originalConfigName.replaceAll("/", "\\\\");
        return "//*[local-name()='router' and namespace-uri()='http://www.mulesoft.org/schema/mule/apikit-soap' and ( ends-with(@config-ref, '" + originalConfigName + "') or ends-with(@config-ref, '" + nameWithInvertedSlashes + "') )]";
    }

    private void addPayloadMapping(Element flow) {
        Element transform = new Element("transform", EE_NAMESPACE);
        Element message = new Element("message", EE_NAMESPACE);
        Element setPayload = new Element("set-payload", EE_NAMESPACE);
        setPayload.addContent((Content)new CDATA(PAYLOAD_MAPPING_SCRIPT));
        message.addContent((Content)setPayload);
        transform.addContent((Content)message);
        flow.addContent((Content)transform);
        this.getApplicationModel().addNameSpace(EE_NAMESPACE_NAME, EE_NAMESPACE_URI, EE_NAMESPACE_SCHEMA);
    }

    private List<Element> getElementByXpath(Document document, String xpath) {
        XPathExpression compiledXPath = XPathFactory.instance().compile(xpath, Filters.element());
        return compiledXPath.evaluate((Object)document);
    }

    public static void soapkitLib(ApplicationModel appModel) {
        try {
            DataWeaveHelper.library(DataWeaveHelper.getMigrationScriptFolder(appModel.getProjectBasePath()), "Soapkit.dwl", "/**" + System.lineSeparator() + " * Write the body as xml string" + System.lineSeparator() + " */" + System.lineSeparator() + "fun soapBody(body: Any) = do { " + System.lineSeparator() + "    if (typeOf(body) as String == \"String\") body " + System.lineSeparator() + "    else body write \"application/xml\"" + System.lineSeparator() + "}" + System.lineSeparator() + System.lineSeparator() + "/**" + System.lineSeparator() + " * Get Soap headers from vars by filtering properties starting with 'soap.'" + System.lineSeparator() + " */" + System.lineSeparator() + "fun soapHeaders(vars: {}) = do {" + System.lineSeparator() + "    var matcher_regex = /(?i)soap\\..*/" + System.lineSeparator() + "    ---" + System.lineSeparator() + "    vars default {} " + System.lineSeparator() + "        filterObject($$ matches matcher_regex)" + System.lineSeparator() + "        mapObject {" + System.lineSeparator() + "            (($$ as String)[5 to -1]): $ write \"application/xml\"" + System.lineSeparator() + "        }" + System.lineSeparator() + "}" + System.lineSeparator() + "" + System.lineSeparator() + "/**" + System.lineSeparator() + " * Get attachments from vars by filtering properties starting with 'att_'" + System.lineSeparator() + " */" + System.lineSeparator() + "fun soapAttachments(vars: {}) = do {" + System.lineSeparator() + "    var matcher_regex = /(?i)att_.*/" + System.lineSeparator() + "    ---" + System.lineSeparator() + "    vars default {} " + System.lineSeparator() + "        filterObject($$ matches matcher_regex)" + System.lineSeparator() + "        mapObject {" + System.lineSeparator() + "            (($$ as String)[4 to -1]): {" + System.lineSeparator() + "                content: $," + System.lineSeparator() + "                contentType: $.^mimeType" + System.lineSeparator() + "            }" + System.lineSeparator() + "        }" + System.lineSeparator() + "}" + System.lineSeparator() + System.lineSeparator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

