/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.soapkit.steps;

import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.category.ProjectStructureContribution;
import com.mulesoft.tools.migration.step.util.ProjectStructureUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public class SoapkitWsdlLocation
implements ProjectStructureContribution {
    static final String MULE_3_API_FOLDER = "src" + File.separator + "main" + File.separator + "wsdl";
    static final String MULE_4_API_FOLDER = "src" + File.separator + "main" + File.separator + "resources" + File.separator + "api";

    public String getDescription() {
        return "Move '" + MULE_3_API_FOLDER + "' content to '" + MULE_4_API_FOLDER + "'";
    }

    public void execute(Path basePath, MigrationReport report) throws RuntimeException {
        File mule3ApiFolder = basePath.resolve(MULE_3_API_FOLDER).toFile();
        File mule4ApiFolder = basePath.resolve(MULE_4_API_FOLDER).toFile();
        try {
            if (mule3ApiFolder.exists()) {
                ProjectStructureUtils.moveDirectory((File)mule3ApiFolder, (File)mule4ApiFolder);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot move api folder", e);
        }
    }
}

