/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.tools.mel;

import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.CompatibilityResolver;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import org.jdom2.Element;

public class OutboundPropertiesCompatibilityResolver
implements CompatibilityResolver<String> {
    public boolean canResolve(String original) {
        return original != null && (original.trim().toLowerCase().startsWith("header:outbound:") || original.trim().toLowerCase().startsWith("header:") && original.split(":").length == 2);
    }

    public String resolve(String original, Element element, MigrationReport report, ApplicationModel model, ExpressionMigrator expressionMigrator) {
        return this.doResolve(original, report);
    }

    public String resolve(String original, Element element, MigrationReport report, ApplicationModel model, ExpressionMigrator expressionMigrator, boolean enricher) {
        String propertyName = this.doResolve(original, report);
        if (enricher) {
            return propertyName;
        }
        return "vars.compatibility_outboundProperties." + propertyName;
    }

    private String doResolve(String original, MigrationReport report) {
        report.melExpressionSuccess(original);
        return original.trim().replaceFirst("(?i)^(header:outbound:|header:)", "");
    }
}

