/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.step.util;

import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.AttributeValueMapper;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.util.CompatibilityResolver;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.jdom2.input.SAXBuilder;
import org.jdom2.located.LocatedJDOMFactory;

public final class XmlDslUtils {
    public static final String CORE_NS_URI = "http://www.mulesoft.org/schema/mule/core";
    public static final Namespace CORE_NAMESPACE = Namespace.getNamespace((String)"http://www.mulesoft.org/schema/mule/core");
    public static final String EE_NAMESPACE_NAME = "ee";
    public static final String CORE_EE_NS_URI = "http://www.mulesoft.org/schema/mule/ee/core";
    public static final Namespace CORE_EE_NAMESPACE = Namespace.getNamespace((String)"ee", (String)"http://www.mulesoft.org/schema/mule/ee/core");
    public static final String EE_NAMESPACE_SCHEMA = "http://www.mulesoft.org/schema/mule/ee/core/current/mule-ee.xsd";

    private XmlDslUtils() {
    }

    public static Element setText(Element element, String text) {
        if (text.contains("<") || text.contains(">") || text.contains("&") || text.contains("'") || text.contains("\"")) {
            element.setContent((Content)new CDATA(text));
        } else {
            element.setText(text);
        }
        return element;
    }

    public static void migrateExpression(Attribute attr, ExpressionMigrator exprMigrator) {
        if (attr != null) {
            attr.setValue(exprMigrator.migrateExpression(attr.getValue(), true, attr.getParent()));
        }
    }

    public static String changeDefault(String oldDefaultValue, String newDefaultValue, String currentValue) {
        if (currentValue == null) {
            return oldDefaultValue;
        }
        if (newDefaultValue.equals(currentValue)) {
            return null;
        }
        return currentValue;
    }

    public static void migrateSourceStructure(ApplicationModel appModel, Element element, MigrationReport report) {
        XmlDslUtils.migrateSourceStructure(appModel, element, report, true, false);
    }

    public static void migrateSourceStructure(ApplicationModel appModel, Element element, MigrationReport report, boolean expectsOutboundProperties, boolean consumeStreams) {
        XmlDslUtils.addCompatibilityNamespace(element.getDocument());
        int index = element.getParent().indexOf((Content)element);
        XmlDslUtils.buildAttributesToInboundProperties(report, element.getParent(), index + 1);
        if (expectsOutboundProperties) {
            Element errorHandlerElement = XmlDslUtils.getFlowExceptionHandlingElement(element.getParentElement());
            if (errorHandlerElement != null) {
                XmlDslUtils.buildOutboundPropertiesToVar(report, element.getParent(), element.getParentElement().indexOf((Content)errorHandlerElement) - 1, consumeStreams);
                errorHandlerElement.getChildren().forEach(eh -> XmlDslUtils.buildOutboundPropertiesToVar(report, (Parent)eh, eh.getContentSize(), consumeStreams));
            } else {
                XmlDslUtils.buildOutboundPropertiesToVar(report, element.getParent(), element.getParent().getContentSize(), consumeStreams);
            }
        }
    }

    public static void migrateOperationStructure(ApplicationModel appModel, Element element, MigrationReport report) {
        XmlDslUtils.migrateOperationStructure(appModel, element, report, true, null, null, false);
    }

    public static void migrateOperationStructure(ApplicationModel appModel, Element element, MigrationReport report, boolean outputsAttributes, ExpressionMigrator expressionMigrator, CompatibilityResolver resolver) {
        XmlDslUtils.migrateOperationStructure(appModel, element, report, outputsAttributes, expressionMigrator, resolver, false);
    }

    public static void migrateOperationStructure(ApplicationModel appModel, Element element, MigrationReport report, boolean outputsAttributes, ExpressionMigrator expressionMigrator, CompatibilityResolver resolver, boolean consumeStreams) {
        if (expressionMigrator != null && resolver != null) {
            XmlDslUtils.migrateEnrichers(element, expressionMigrator, resolver, appModel, report);
        }
        XmlDslUtils.addCompatibilityNamespace(element.getDocument());
        int index = element.getParent().indexOf((Content)element);
        if (!"true".equals(element.getAttributeValue("isPolledConsumer", Namespace.getNamespace((String)"migration", (String)"migration")))) {
            XmlDslUtils.buildOutboundPropertiesToVar(report, element.getParent(), index, consumeStreams);
        }
        if (outputsAttributes) {
            XmlDslUtils.buildAttributesToInboundProperties(report, element.getParent(), index + 2);
        }
    }

    public static void migrateEnrichers(Element element, ExpressionMigrator expressionMigrator, CompatibilityResolver<String> resolver, ApplicationModel appModel, MigrationReport report) {
        String targetValue = element.getAttributeValue("target");
        if (StringUtils.isNotBlank((CharSequence)targetValue)) {
            String migratedExpression = expressionMigrator.migrateExpression(targetValue, true, element, true);
            element.setAttribute("target", expressionMigrator.unwrap(migratedExpression));
            if (resolver.canResolve(expressionMigrator.unwrap(targetValue))) {
                XmlDslUtils.addOutboundPropertySetter(expressionMigrator.unwrap(migratedExpression), element, appModel, element);
                report.report("message.outboundPropertyEnricher", element, element, new String[0]);
            }
        }
    }

    public static Element addOutboundPropertySetter(String propertyName, Element element, ApplicationModel appModel, Element after) {
        XmlDslUtils.addCompatibilityNamespace(element.getDocument());
        Element setProperty = new Element("set-property", TransportsUtils.COMPATIBILITY_NAMESPACE);
        setProperty.setAttribute(new Attribute("propertyName", propertyName));
        setProperty.setAttribute(new Attribute("value", "#[vars." + propertyName + "]"));
        XmlDslUtils.addElementAfter(setProperty, after);
        return setProperty;
    }

    private static Element buildAttributesToInboundProperties(MigrationReport report, Parent parent, int index) {
        Element a2ip = new Element("attributes-to-inbound-properties", TransportsUtils.COMPATIBILITY_NAMESPACE);
        parent.addContent(index, (Content)a2ip);
        report.report("message.attributesToInboundProperties", a2ip, a2ip, new String[0]);
        return a2ip;
    }

    private static Element buildOutboundPropertiesToVar(MigrationReport report, Parent parent, int index, boolean consumeStreams) {
        Element op2v = new Element("outbound-properties-to-var", TransportsUtils.COMPATIBILITY_NAMESPACE);
        if (consumeStreams) {
            op2v.setAttribute("consumeStreams", "true");
        }
        parent.addContent(index, (Content)op2v);
        report.report("message.outboundProperties", op2v, op2v, new String[0]);
        return op2v;
    }

    public static void migrateRedeliveryPolicyChildren(Element redeliveryPolicy, MigrationReport report) {
        Element dlq = redeliveryPolicy.getChild("dead-letter-queue", CORE_NAMESPACE);
        if (dlq != null) {
            Optional<Element> redeliveryExhaustedHandler;
            Element flow = XmlDslUtils.getContainerElement(redeliveryPolicy);
            Element errorHandler = XmlDslUtils.getFlowExceptionHandlingElement(flow);
            if (errorHandler == null) {
                errorHandler = new Element("error-handler", CORE_NAMESPACE);
                flow.addContent((Content)errorHandler);
            }
            if ((redeliveryExhaustedHandler = errorHandler.getChildren().stream().filter(e -> "REDELIVERY_EXHAUSTED".equals(e.getAttributeValue("type"))).findFirst()).isPresent()) {
                report.report("flow.redeliveryExhausted", dlq, redeliveryPolicy, new String[0]);
            } else {
                Element handler = new Element("on-error-propagate", CORE_NAMESPACE).setAttribute("type", "REDELIVERY_EXHAUSTED");
                errorHandler.addContent(0, (Content)handler);
                handler.addContent((Collection)dlq.getChildren().stream().map(c -> c.detach()).collect(Collectors.toList()));
            }
            dlq.detach();
        }
    }

    public static void addCompatibilityNamespace(Document document) {
        ApplicationModel.addNameSpace(TransportsUtils.COMPATIBILITY_NAMESPACE, "http://www.mulesoft.org/schema/mule/compatibility/current/mule-compatibility.xsd", document);
    }

    public static boolean copyAttributeIfPresent(Element source, Element target, String attributeName) {
        return XmlDslUtils.copyAttributeIfPresent(source, target, attributeName, attributeName, attrValue -> attrValue, true);
    }

    public static boolean copyAttributeIfPresent(Element source, Element target, String sourceAttributeName, String targetAttributeName) {
        return XmlDslUtils.copyAttributeIfPresent(source, target, sourceAttributeName, targetAttributeName, attrValue -> attrValue, true);
    }

    public static boolean copyAttributeIfPresent(Element source, Element target, String sourceAttributeName, String targetAttributeName, boolean removeSource) {
        return XmlDslUtils.copyAttributeIfPresent(source, target, sourceAttributeName, targetAttributeName, attrValue -> attrValue, removeSource);
    }

    public static boolean copyAttributeIfPresent(Element source, Element target, String sourceAttributeName, String targetAttributeName, AttributeValueMapper<String> attributeValueMapper) {
        return XmlDslUtils.copyAttributeIfPresent(source, target, sourceAttributeName, targetAttributeName, attributeValueMapper, true);
    }

    public static boolean copyAttributeIfPresent(Element source, Element target, String attributeName, boolean removeSource) {
        return XmlDslUtils.copyAttributeIfPresent(source, target, attributeName, attributeName, attrValue -> attrValue, removeSource);
    }

    public static boolean copyAttributeIfPresent(Element source, Element target, String attributeName, AttributeValueMapper<String> attributeValueMapper, boolean removeSource) {
        return XmlDslUtils.copyAttributeIfPresent(source, target, attributeName, attributeName, attributeValueMapper, removeSource);
    }

    public static boolean copyAttributeIfPresent(Element source, Element target, String sourceAttributeName, String targetAttributeName, AttributeValueMapper<String> attributeValueMapper, boolean removeSource) {
        if (XmlDslUtils.hasAttribute(source, sourceAttributeName)) {
            target.setAttribute(targetAttributeName, attributeValueMapper.getAttributeValue(source.getAttributeValue(sourceAttributeName)));
            if (removeSource) {
                source.removeAttribute(sourceAttributeName);
            }
            return true;
        }
        return false;
    }

    public static boolean hasAttribute(Element source, String sourceAttributeName) {
        return source.getAttribute(sourceAttributeName) != null;
    }

    public static void addElementBefore(Element newElement, Element element) {
        Integer elementIndex = element.getParentElement().indexOf((Content)element);
        element.getParentElement().addContent(elementIndex.intValue(), (Content)newElement);
    }

    public static void addElementAfter(Element newElement, Element element) {
        Integer elementIndex = element.getParentElement().indexOf((Content)element);
        element.getParentElement().addContent(elementIndex + 1, (Content)newElement);
    }

    public static void addElementsAfter(Collection<? extends Content> newElements, Element element) {
        Integer elementIndex = element.getParentElement().indexOf((Content)element);
        element.getParentElement().addContent(elementIndex + 1, newElements);
    }

    public static Element getContainerElement(Element processor) {
        while (!(processor == null || "flow".equals(processor.getName()) || "sub-flow".equals(processor.getName()) || "before".equals(processor.getName()) || "after".equals(processor.getName()))) {
            processor = processor.getParentElement();
        }
        return processor;
    }

    public static boolean isTopLevelElement(Element element) {
        return element.getParentElement().equals((Object)element.getDocument().getRootElement());
    }

    public static void createErrorHandlerParent(Element element) {
        Element parent = element.getParentElement();
        element.detach();
        Element errorHandler = new Element("error-handler");
        errorHandler.setNamespace(CORE_NAMESPACE);
        errorHandler.addContent((Content)element);
        if (element.getAttribute("name") != null) {
            Attribute name = element.getAttribute("name");
            name.detach();
            errorHandler.setAttribute(name);
        }
        parent.addContent((Content)errorHandler);
    }

    public static void removeAttribute(Element element, String attributeName) {
        if (XmlDslUtils.hasAttribute(element, attributeName)) {
            element.removeAttribute(attributeName);
        }
    }

    public static void removeAllAttributes(Element element) {
        List<Attribute> attributes = element.getAttributes().stream().collect(Collectors.toList());
        attributes.forEach(Attribute::detach);
    }

    public static void addMigrationAttributeToElement(Element element, Attribute attribute) {
        attribute.setNamespace(Namespace.getNamespace((String)"migration", (String)"migration"));
        element.setAttribute(attribute);
    }

    public static boolean isErrorHanldingElement(Element element) {
        return element.getName().matches("choice-exception-strategy|catch-exception-strategy|rollback-exception-strategy|exception-strategy|error-handler");
    }

    public static Element getFlowExceptionHandlingElement(Element flow) {
        return flow.getChildren().stream().filter(e -> XmlDslUtils.isErrorHanldingElement(e)).findFirst().orElse(null);
    }

    public static void addElementToBottom(Element flow, Content newElement) {
        Element exceptionHandling = XmlDslUtils.getFlowExceptionHandlingElement(flow);
        Integer newElementIndex = exceptionHandling != null ? flow.indexOf((Content)exceptionHandling) : flow.getContentSize();
        flow.addContent(newElementIndex.intValue(), newElement);
    }

    public static void addTopLevelElement(Element element, Document document) {
        Integer elementIndex = document.getRootElement().getContent().indexOf(document.getRootElement().getChildren().stream().filter(c -> c.getName().matches("flow|sub-flow")).findFirst().orElse(null));
        if (elementIndex >= 0) {
            document.getRootElement().addContent(elementIndex.intValue(), (Content)element);
        } else {
            elementIndex = document.getRootElement().getContent().size();
            document.getRootElement().addContent(elementIndex > 0 ? elementIndex - 1 : 0, (Content)element);
        }
    }

    public static void migrateReconnection(Element m4Connection, Element m3Connector, MigrationReport report) {
        String failsDeployment = XmlDslUtils.changeDefault("true", "false", m3Connector.getAttributeValue("validateConnections"));
        m3Connector.removeAttribute("validateConnections");
        Element reconnection = new Element("reconnection", CORE_NAMESPACE);
        if (failsDeployment != null) {
            reconnection.setAttribute("failsDeployment", failsDeployment);
            m4Connection.addContent((Content)reconnection);
        }
        XmlDslUtils.migrateReconnect(m3Connector, reconnection, report, m4Connection);
    }

    public static void migrateReconnect(Element m3Connection, Element m4Reconnection, MigrationReport report, Element parent) {
        Element reconnect;
        Element reconnectForever = m3Connection.getChild("reconnect-forever", CORE_NAMESPACE);
        if (reconnectForever != null) {
            m4Reconnection.addContent((Content)reconnectForever.detach());
        }
        if ((reconnect = m3Connection.getChild("reconnect", CORE_NAMESPACE)) != null) {
            Element m4Reconnect = reconnect.detach();
            if (m4Reconnect.getChild("reconnect-notifier", CORE_NAMESPACE) != null || m4Reconnect.getChild("reconnect-custom-notifier", CORE_NAMESPACE) != null) {
                report.report("connectors.reconnectNotifiers", reconnect, parent, new String[0]);
                m4Reconnect.removeChildren("reconnect-notifier", CORE_NAMESPACE);
                m4Reconnect.removeChildren("reconnect-custom-notifier", CORE_NAMESPACE);
            }
            if (m4Reconnect.hasAttributes() || !m4Reconnect.getChildren().isEmpty()) {
                m4Reconnection.addContent((Content)m4Reconnect);
            }
        }
    }

    public static Element addNewFlowAfter(String name, Element previousSibling) {
        Element flow = new Element("flow", CORE_NAMESPACE);
        flow.setAttribute("name", name);
        XmlDslUtils.addElementAfter(flow, previousSibling);
        return flow;
    }

    public static Document generateDocument(Path filePath) throws JDOMException, IOException {
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setJDOMFactory((JDOMFactory)new LocatedJDOMFactory());
        return saxBuilder.build(filePath.toFile());
    }

    public static boolean isMuleConfigFile(String fileName, Path appBasePath) {
        File xmlFile;
        boolean muleConfig = false;
        if (fileName.endsWith("xml") && (xmlFile = (File)FileUtils.listFiles((File)appBasePath.toFile(), (String[])new String[]{"xml"}, (boolean)true).stream().filter(f -> f.getName().equals(fileName.replace("classpath:", ""))).findFirst().orElse(null)) != null) {
            try {
                Document doc = XmlDslUtils.generateDocument(xmlFile.toPath());
                if (doc.getRootElement().getNamespace().getURI().startsWith("http://www.mulesoft.org/schema/mule/")) {
                    muleConfig = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return muleConfig;
    }

    public static String getXPathSelector(String namespaceUri, String elementName) {
        return XmlDslUtils.getXPathSelector(namespaceUri, elementName, false);
    }

    public static String getTopLevelXPathSelector(String namespaceUri, String elementName) {
        return XmlDslUtils.getXPathSelector(namespaceUri, elementName, true);
    }

    public static String getXPathSelector(String namespaceUri, String elementName, boolean topLevel) {
        return String.format("%s[namespace-uri() = '%s' and local-name() = '%s']", topLevel ? "/*/*" : "//*", namespaceUri, elementName);
    }

    public static String getAllElementsFromNamespaceXpathSelector(String namespaceUri, List<String> elements, boolean topLevel) {
        String localNameExpression = elements.stream().map(e -> String.format("local-name() = '%s'", e)).collect(Collectors.joining(" or "));
        return String.format("%s[namespace-uri() = '%s' and (%s)]", topLevel ? "/*/*" : "//*", namespaceUri, localNameExpression);
    }

    public static String getCoreXPathSelector(String elementName) {
        return XmlDslUtils.getCoreXPathSelector(elementName, false);
    }

    public static String getTopLevelCoreXPathSelector(String elementName) {
        return XmlDslUtils.getCoreXPathSelector(elementName, true);
    }

    private static String getCoreXPathSelector(String elementName, boolean topLevel) {
        return XmlDslUtils.getXPathSelector(CORE_NS_URI, elementName, topLevel);
    }

    public static void removeNestedComments(Element element) {
        Iterator contentIterator = element.getContent().iterator();
        while (contentIterator.hasNext()) {
            Content content = (Content)contentIterator.next();
            if (content instanceof Comment) {
                contentIterator.remove();
            }
            if (!(content instanceof Element)) continue;
            Element contentElement = (Element)content;
            XmlDslUtils.removeNestedComments(contentElement);
        }
    }

    public static boolean isAncestorOf(Element ancestor, Element descendant) {
        if (ancestor == null || descendant == null) {
            return false;
        }
        for (Element element = descendant; element != null; element = element.getParentElement()) {
            if (element != ancestor) continue;
            return true;
        }
        return false;
    }
}

