/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.engine.project.structure.util;

import com.mulesoft.tools.migration.engine.project.structure.util.Exclusions;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;

public class CopyFileVisitor
implements FileVisitor<Path> {
    private final File fromFolder;
    private final File targetFolder;

    public CopyFileVisitor(File fromFolder, File targetFolder) {
        this.fromFolder = fromFolder;
        this.targetFolder = targetFolder;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.doExclude(this.fromFolder.toPath().relativize(dir)).booleanValue()) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        Path targetPath = this.targetFolder.toPath().resolve(this.fromFolder.toPath().relativize(dir));
        if (!Files.exists(targetPath, new LinkOption[0])) {
            Files.createDirectory(targetPath, new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.doExclude(this.fromFolder.toPath().relativize(file)).booleanValue()) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        Files.copy(file, this.targetFolder.toPath().resolve(this.fromFolder.toPath().relativize(file)), StandardCopyOption.REPLACE_EXISTING);
        return FileVisitResult.CONTINUE;
    }

    private Boolean doExclude(Path path) {
        return Arrays.stream(Exclusions.values()).anyMatch(e -> (File.separator + path.toString()).equals(e.exclusion()));
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        return FileVisitResult.CONTINUE;
    }
}

