/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.report;

import com.mulesoft.tools.migration.exception.MigrationAbortException;
import com.mulesoft.tools.migration.project.ProjectType;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.report.html.model.ReportEntryModel;
import com.mulesoft.tools.migration.step.category.ComponentMigrationStatus;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;
import org.yaml.snakeyaml.Yaml;

public class DefaultMigrationReport
implements MigrationReport<ReportEntryModel> {
    public static final Pattern WORD_MESSAGE_REPLACEMENT_EXPRESSION = Pattern.compile("\\{\\w*\\}");
    private transient Map<String, Map<String, Map<String, Object>>> possibleEntries;
    private transient XMLOutputter outp = new XMLOutputter();
    private final Set<ReportEntryModel> reportEntries = new LinkedHashSet<ReportEntryModel>();
    private String projectType;
    private String projectName;
    private double successfulMigrationRatio;
    private double errorMigrationRatio;
    private int processedElements;
    private final Map<String, ComponentMigrationStatus> components = new LinkedHashMap<String, ComponentMigrationStatus>();
    private final Set<String> connectors = new LinkedHashSet<String>();
    private int dwTransformsSuccess;
    private int dwTransformsFailure;
    private int dwTransformLinesSuccess;
    private int dwTransformLinesFailure;
    private int melExpressionsSuccess;
    private int melExpressionsFailure;
    private int melLinesSuccess;
    private int melLinesFailure;

    public DefaultMigrationReport() {
        this.possibleEntries = new HashMap<String, Map<String, Map<String, Object>>>();
        try {
            for (URL reportYamlUrl : Collections.list(DefaultMigrationReport.class.getClassLoader().getResources("report.yaml"))) {
                InputStream yamlStream = reportYamlUrl.openStream();
                Throwable throwable = null;
                try {
                    this.possibleEntries.putAll((Map)new Yaml().loadAs(yamlStream, Map.class));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (yamlStream == null) continue;
                    if (throwable != null) {
                        try {
                            yamlStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    yamlStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new MigrationAbortException("Couldn't load report entries definitions.", (Exception)e);
        }
    }

    public void initialize(ProjectType projectType, String projectName) {
        this.projectType = projectType.name();
        this.projectName = projectName;
    }

    public void report(String entryKey, Element element, Element elementToComment, String ... messageParams) {
        String[] splitEntryKey = entryKey.split("\\.");
        Map<String, Object> entryData = this.possibleEntries.get(splitEntryKey[0]).get(splitEntryKey[1]);
        MigrationReport.Level level = MigrationReport.Level.valueOf((String)((String)entryData.get("type")));
        String message = (String)entryData.get("message");
        Matcher matcher = WORD_MESSAGE_REPLACEMENT_EXPRESSION.matcher(message);
        StringBuilder result = new StringBuilder();
        int i = 0;
        int currentIndex = 0;
        while (matcher.find(currentIndex)) {
            int start = matcher.start();
            result.append(message, currentIndex, start);
            if (messageParams.length > i) {
                result.append(messageParams[i]);
            }
            currentIndex = matcher.end();
            ++i;
        }
        result.append(message.substring(currentIndex));
        List docLinks = entryData.get("docLinks") != null ? (List)entryData.get("docLinks") : Collections.emptyList();
        this.report(entryKey, level, element, elementToComment, result.toString(), docLinks.toArray(new String[docLinks.size()]));
    }

    public void report(MigrationReport.Level level, Element element, Element elementToComment, String message, String ... documentationLinks) {
        this.report(null, level, element, elementToComment, message, documentationLinks);
    }

    private void report(String entryKey, MigrationReport.Level level, Element element, Element elementToComment, String message, String ... documentationLinks) {
        int i = 0;
        if (elementToComment != null) {
            ReportEntryModel reportEntry;
            if (elementToComment != element) {
                i = this.findContentIndex(element, elementToComment);
            }
            if (this.reportEntries.add(reportEntry = elementToComment.getDocument() != null || element.getDocument() == null ? new ReportEntryModel(entryKey, level, elementToComment, message, documentationLinks) : new ReportEntryModel(entryKey, level, elementToComment, message, element.getDocument(), documentationLinks))) {
                elementToComment.addContent(i++, (Content)new Comment("Migration " + level.name() + ": " + this.sanitize(message)));
                if (documentationLinks.length > 0) {
                    elementToComment.addContent(i++, (Content)new Comment("    For more information refer to:"));
                    for (String link : documentationLinks) {
                        elementToComment.addContent(i++, (Content)new Comment("        * " + this.sanitize(link)));
                    }
                }
                if (!XmlDslUtils.isAncestorOf((Element)element, (Element)elementToComment)) {
                    XmlDslUtils.removeNestedComments((Element)element);
                    elementToComment.addContent(i, (Content)new Comment(this.sanitize(this.outp.outputString(element))));
                }
            }
        }
    }

    private int findContentIndex(Element element, Element elementToComment) {
        int i;
        for (i = 0; i < elementToComment.getContent().size() && !element.toString().equals(elementToComment.getContent(i).toString()); ++i) {
        }
        return i < elementToComment.getContent().size() ? i : 0;
    }

    private String sanitize(String message) {
        return message.replaceAll("--", " - - ");
    }

    public void addProcessedElements(int processedElements) {
        this.processedElements += processedElements;
        this.successfulMigrationRatio = 1.0 * (double)((long)this.processedElements - this.reportEntries.stream().filter(re -> re.getElement() != null && !"compatibility".equals(re.getElement().getNamespacePrefix())).map(re -> re.getElement()).distinct().count()) / (double)this.processedElements;
        this.errorMigrationRatio = 1.0 * (double)this.reportEntries.stream().filter(re -> re.getElement() != null && MigrationReport.Level.ERROR.equals((Object)re.getLevel())).map(re -> re.getElement()).distinct().count() / (double)this.processedElements;
    }

    public void updateReportEntryFilePath(Path oldFileName, Path newFileName) {
        this.reportEntries.stream().filter(e -> oldFileName.toString().equals(e.getFilePath())).forEach(r -> r.setFilePath(newFileName.toString()));
    }

    public String getProjectType() {
        return this.projectType;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public List<ReportEntryModel> getReportEntries() {
        return new ArrayList<ReportEntryModel>(this.reportEntries);
    }

    public List<ReportEntryModel> getReportEntries(MigrationReport.Level ... levels) {
        List<MigrationReport.Level> levelList = Arrays.asList(levels);
        return this.reportEntries.stream().filter(e -> levelList.contains(e.getLevel())).collect(Collectors.toList());
    }

    public double getSuccessfulMigrationRatio() {
        return this.successfulMigrationRatio;
    }

    public double getErrorMigrationRatio() {
        return this.errorMigrationRatio;
    }

    public List<String> getConnectorNames() {
        return new ArrayList<String>(this.connectors);
    }

    public void addConnectors(PomModel pomModel) {
        pomModel.getDependencies().stream().filter(d -> d.getGroupId().contains("connector") || d.getArtifactId().contains("connector")).forEach(d -> this.connectors.add(String.format("%s:%s:%s", d.getGroupId(), d.getArtifactId(), d.getVersion())));
    }

    public Integer getComponentSuccessCount() {
        return this.components.values().stream().map(ComponentMigrationStatus::getSuccess).reduce(0, Integer::sum);
    }

    public Integer getComponentFailureCount() {
        return this.components.values().stream().map(ComponentMigrationStatus::getFailure).reduce(0, Integer::sum);
    }

    public Integer getComponentCount() {
        return this.getComponentSuccessCount() + this.getComponentFailureCount();
    }

    public Map<String, ComponentMigrationStatus> getComponents() {
        return this.components;
    }

    public String getComponentKey(Element element) {
        return DefaultMigrationReport.getComponentKeyStatic(element);
    }

    public static String getComponentKeyStatic(Element element) {
        String prefix = StringUtils.isBlank((CharSequence)element.getNamespace().getPrefix()) ? "" : element.getNamespace().getPrefix() + ":";
        return prefix + element.getName();
    }

    public void addComponentSuccess(Element element) {
        String name = this.getComponentKey(element);
        this.components.putIfAbsent(name, new ComponentMigrationStatus());
        this.components.get(name).success();
    }

    public void addComponentFailure(Element element) {
        String name = this.getComponentKey(element);
        this.components.putIfAbsent(name, new ComponentMigrationStatus());
        this.components.get(name).failure();
    }

    public Integer getDwTransformsSuccessCount() {
        return this.dwTransformsSuccess;
    }

    public Integer getDwTransformsFailureCount() {
        return this.dwTransformsFailure;
    }

    public Integer getDwTransformsCount() {
        return this.dwTransformsSuccess + this.dwTransformsFailure;
    }

    public Integer getDwTransformsSuccessLineCount() {
        return this.dwTransformLinesSuccess;
    }

    public Integer getDwTransformsFailureLineCount() {
        return this.dwTransformLinesFailure;
    }

    public Integer getDwTransformsLineCount() {
        return this.dwTransformLinesSuccess + this.dwTransformLinesFailure;
    }

    public void dwTransformsSuccess(String script) {
        ++this.dwTransformsSuccess;
        int lines = this.countLines(script);
        this.dwTransformLinesSuccess += lines;
    }

    public void dwTransformsFailure(String script) {
        ++this.dwTransformsFailure;
        int lines = this.countLines(script);
        this.dwTransformLinesFailure += lines;
    }

    public Integer getMelExpressionsSuccessCount() {
        return this.melExpressionsSuccess;
    }

    public Integer getMelExpressionsFailureCount() {
        return this.melExpressionsFailure;
    }

    public Integer getMelExpressionsCount() {
        return this.melExpressionsFailure + this.melExpressionsSuccess;
    }

    public Integer getMelExpressionsSuccessLineCount() {
        return this.melLinesSuccess;
    }

    public Integer getMelExpressionsFailureLineCount() {
        return this.melLinesFailure;
    }

    public Integer getMelExpressionsLineCount() {
        return this.melLinesFailure + this.melLinesSuccess;
    }

    public void melExpressionSuccess(String melExpression) {
        ++this.melExpressionsSuccess;
        int lines = this.countLines(melExpression);
        this.melLinesSuccess += lines;
    }

    public void melExpressionFailure(String melExpression) {
        ++this.melExpressionsFailure;
        int lines = this.countLines(melExpression);
        this.melLinesFailure += lines;
    }

    private int countLines(String melExpression) {
        return melExpression.split("\\r\\n|\\r|\\n").length;
    }
}

