/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.printer;

import com.mulesoft.tools.migration.report.DefaultMigrationReport;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ConsolePrinter {
    public static void log(String message) {
        System.out.println(message);
    }

    public static void printMigrationSummary(String reportPath, Long elapsedTime, DefaultMigrationReport report) {
        ConsolePrinter.log("===============================================================================");
        ConsolePrinter.log("MIGRATION ASSISTANT RUN SUCCESSFULLY");
        ConsolePrinter.log("===============================================================================");
        ConsolePrinter.log("Total time: " + String.format("%.3f", Float.valueOf(elapsedTime.floatValue() / 1000.0f)) + " s");
        ConsolePrinter.log("Migration report: " + reportPath);
    }

    public static void printMigrationError(Exception exception, Long elapsedTime) {
        ConsolePrinter.log("===============================================================================");
        ConsolePrinter.log("MIGRATION FAILED");
        ConsolePrinter.log("===============================================================================");
        ConsolePrinter.log("Total time: " + String.format("%.3f", Float.valueOf(elapsedTime.floatValue() / 1000.0f)) + " s");
        ConsolePrinter.log("Exception: " + exception.getMessage());
        StringWriter exceptionWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(exceptionWriter));
        ConsolePrinter.log(exceptionWriter.toString());
        ConsolePrinter.log("===============================================================================");
    }
}

