/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.apikit.steps;

import com.mulesoft.tools.migration.library.apikit.ApikitUriParamUtils;
import com.mulesoft.tools.migration.library.apikit.steps.AbstractApikitMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;

public class ApikitFlowUriParams
extends AbstractApikitMigrationStep {
    private static final String XPATH_SELECTOR = "//*[local-name()='flow' and namespace-uri()='http://www.mulesoft.org/schema/mule/core' and contains(@name, '\\(') and contains(@name, ')')]";

    public ApikitFlowUriParams() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public String getDescription() {
        return null;
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        ApikitUriParamUtils.addVariableDeclarationFor(element, this.getUriParamsFrom(element));
    }

    public boolean shouldReportMetrics() {
        return false;
    }

    private List<String> getUriParamsFrom(Element flow) {
        ArrayList<String> result = new ArrayList<String>();
        String flowName = flow.getAttributeValue("name");
        if (!StringUtils.isBlank((CharSequence)flowName)) {
            Matcher m = Pattern.compile("\\\\\\(.*?\\)").matcher(flowName);
            while (m.find()) {
                String uriParam = m.group().replaceAll("\\\\\\(|\\)", "");
                result.add(uriParam);
            }
        }
        return result;
    }
}

