/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.applicationgraph;

import com.google.common.collect.ImmutableList;
import com.mulesoft.tools.migration.library.applicationgraph.PropertiesSourceType;
import com.mulesoft.tools.migration.library.nocompatibility.InboundToAttributesTranslator;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.project.model.applicationgraph.ApplicationGraph;
import com.mulesoft.tools.migration.project.model.applicationgraph.BasicFlowComponent;
import com.mulesoft.tools.migration.project.model.applicationgraph.Flow;
import com.mulesoft.tools.migration.project.model.applicationgraph.FlowComponent;
import com.mulesoft.tools.migration.project.model.applicationgraph.FlowRefFlowComponent;
import com.mulesoft.tools.migration.project.model.applicationgraph.InvalidGraphStateException;
import com.mulesoft.tools.migration.project.model.applicationgraph.MessageSourceFlowComponent;
import com.mulesoft.tools.migration.project.model.applicationgraph.OperationSourceFlowComponent;
import com.mulesoft.tools.migration.project.model.applicationgraph.PropertyTranslator;
import com.mulesoft.tools.migration.project.model.applicationgraph.SourceType;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.Filter;
import org.jdom2.filter.Filters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationGraphCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationGraphCreator.class);
    private static final String FLOW_XPATH = XmlDslUtils.getAllElementsFromNamespaceXpathSelector((String)"http://www.mulesoft.org/schema/mule/core", (List)ImmutableList.of((Object)"flow", (Object)"sub-flow"), (boolean)true, (boolean)false);
    public static final String MESSAGE_SOURCE_FILTER_EXPRESSION = XmlDslUtils.getAllElementsFromNamespaceXpathSelector(InboundToAttributesTranslator.getSupportedConnectors().stream().collect(Collectors.groupingBy(SourceType::getNamespaceUri, Collectors.mapping(SourceType::getType, Collectors.toList()))), (boolean)false, (boolean)true);

    public ApplicationGraph create(ApplicationModel applicationModel, MigrationReport report) {
        List<Flow> applicationFlows = applicationModel.getApplicationDocuments().values().stream().map(this::getFlows).flatMap(Collection::stream).collect(Collectors.toList());
        ApplicationGraph applicationGraph = new ApplicationGraph(this.getPropertyTranslator(applicationModel), applicationFlows);
        applicationFlows.forEach(flow -> {
            List<FlowComponent> flowComponents = this.getFlowComponents((Flow)flow, applicationGraph);
            flow.setComponents(flowComponents);
            applicationGraph.linealFlowWiring(flow);
        });
        try {
            applicationGraph.muleFlowWiring();
        }
        catch (InvalidGraphStateException e) {
            LOGGER.warn("Could not generate application graph: " + e.getMessage());
        }
        return applicationGraph;
    }

    private List<FlowComponent> getFlowComponents(Flow flow, ApplicationGraph applicationGraph) {
        Element flowAsXmL = flow.getXmlElement();
        return flowAsXmL.getContent().stream().filter(Element.class::isInstance).map(Element.class::cast).map(xmlElement -> this.createFlowComponent((Element)xmlElement, flow, applicationGraph)).collect(Collectors.toList());
    }

    private FlowComponent createFlowComponent(Element xmlElement, Flow parentFlow, ApplicationGraph applicationGraph) {
        if (this.isMessageSource(xmlElement, parentFlow)) {
            return new MessageSourceFlowComponent(xmlElement, parentFlow, applicationGraph, (SourceType)PropertiesSourceType.getRegistered(xmlElement.getNamespaceURI(), xmlElement.getName()));
        }
        if (this.isOperationSource(xmlElement, parentFlow)) {
            return new OperationSourceFlowComponent(xmlElement, parentFlow, applicationGraph, (SourceType)PropertiesSourceType.getRegistered(xmlElement.getNamespaceURI(), xmlElement.getName()));
        }
        if ("flow-ref".equals(xmlElement.getName())) {
            return new FlowRefFlowComponent(xmlElement, parentFlow, applicationGraph);
        }
        return new BasicFlowComponent(xmlElement, parentFlow, applicationGraph);
    }

    private boolean isMessageSource(Element element, Flow flow) {
        return this.isPropertySource(element, flow) && element.getName().matches("(listener|inbound|polling).*");
    }

    private boolean isOperationSource(Element element, Flow flow) {
        return this.isPropertySource(element, flow) && !this.isMessageSource(element, flow);
    }

    private boolean isPropertySource(Element element, Flow flow) {
        List propertySources = XmlDslUtils.getChildrenMatchingExpression((Element)flow.getXmlElement(), (String)MESSAGE_SOURCE_FILTER_EXPRESSION, (Filter)Filters.element());
        return propertySources.contains(element);
    }

    private List<Flow> getFlows(Document document) {
        List flowsAsXml = XmlDslUtils.getChildrenMatchingExpression((Element)document.getRootElement(), (String)FLOW_XPATH, (Filter)Filters.element());
        return flowsAsXml.stream().map(this::convertToFlow).collect(Collectors.toList());
    }

    private Flow convertToFlow(Element flowAsXml) {
        return new Flow(flowAsXml);
    }

    private PropertyTranslator getPropertyTranslator(ApplicationModel applicationModel) {
        InboundToAttributesTranslator translator = new InboundToAttributesTranslator();
        translator.initializeTranslationsForApplicationSourceTypes(applicationModel);
        return translator;
    }
}

