/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.applicationgraph;

import com.google.common.collect.ImmutableList;
import com.mulesoft.tools.migration.project.model.applicationgraph.SourceType;
import java.util.List;
import java.util.Objects;

public class PropertiesSourceType
implements SourceType,
Comparable<PropertiesSourceType> {
    public static final PropertiesSourceType HTTP_LISTENER = new PropertiesSourceType("http://www.mulesoft.org/schema/mule/http", "listener", true, "headers", true);
    public static final PropertiesSourceType HTTP_TRANSPORT = new PropertiesSourceType("http://www.mulesoft.org/schema/mule/http", "inbound-endpoint", true, "headers", true);
    public static final PropertiesSourceType HTTP_CONNECTOR_REQUESTER = new PropertiesSourceType("http://www.mulesoft.org/schema/mule/http", "request", true, "headers", false);
    public static final PropertiesSourceType HTTP_TRANSPORT_OUTBOUND = new PropertiesSourceType("http://www.mulesoft.org/schema/mule/http", "outbound-endpoint", false);
    public static final PropertiesSourceType HTTP_POLLING_CONNECTOR = new PropertiesSourceType("http://www.mulesoft.org/schema/mule/http", "polling-connector", true);
    public static final PropertiesSourceType FILE_INBOUND = new PropertiesSourceType("http://www.mulesoft.org/schema/mule/file", "inbound-endpoint", true);
    public static final PropertiesSourceType IMAP_INBOUND = new PropertiesSourceType("http://www.mulesoft.org/schema/mule/imap", "inbound-endpoint", true);
    public static final PropertiesSourceType POP3_INBOUND = new PropertiesSourceType("http://www.mulesoft.org/schema/mule/pop3", "inbound-endpoint", true);
    public static final PropertiesSourceType FTP_INBOUND = new PropertiesSourceType("http://www.mulesoft.org/schema/mule/ftp", "inbound-endpoint", true);
    public static final PropertiesSourceType JMS_INBOUND = new PropertiesSourceType("http://www.mulesoft.org/schema/mule/jms", "inbound-endpoint", true);
    public static final PropertiesSourceType JMS_OUTBOUND = new PropertiesSourceType("http://www.mulesoft.org/schema/mule/jms", "outbound-endpoint", false);
    public static final PropertiesSourceType REQUEST_REPLY = new PropertiesSourceType("http://www.mulesoft.org/schema/mule/core", "request-reply", false);
    public static final PropertiesSourceType QUARTZ_INBOUND = new PropertiesSourceType("http://www.mulesoft.org/schema/mule/quartz", "inbound-endpoint", true);
    public static final PropertiesSourceType SFTP_INBOUND = new PropertiesSourceType("http://www.mulesoft.org/schema/mule/sftp", "inbound-endpoint", true);
    public static final PropertiesSourceType WS_CONSUMER = new PropertiesSourceType("http://www.mulesoft.org/schema/mule/ws", "consumer", false);
    public static List<PropertiesSourceType> registeredSourceTypes = new ImmutableList.Builder().add((Object)HTTP_LISTENER).add((Object)HTTP_TRANSPORT).add((Object)HTTP_CONNECTOR_REQUESTER).add((Object)HTTP_TRANSPORT_OUTBOUND).add((Object)HTTP_POLLING_CONNECTOR).add((Object)FILE_INBOUND).add((Object)IMAP_INBOUND).add((Object)POP3_INBOUND).add((Object)FTP_INBOUND).add((Object)JMS_INBOUND).add((Object)JMS_OUTBOUND).add((Object)REQUEST_REPLY).add((Object)QUARTZ_INBOUND).add((Object)SFTP_INBOUND).add((Object)WS_CONSUMER).build();
    private String namespaceUri;
    private String type;
    private boolean supportsImplicit;
    private String implicitPrefix = null;
    private boolean isFlowSource;

    public static PropertiesSourceType getRegistered(String namespaceUri, String name) {
        return registeredSourceTypes.stream().filter(registered -> new PropertiesSourceType(namespaceUri, name).equals(registered)).findFirst().orElse(null);
    }

    public PropertiesSourceType(String namespaceUri, String type) {
        this.namespaceUri = namespaceUri;
        this.type = type;
        this.supportsImplicit = false;
    }

    public PropertiesSourceType(String namespaceUri, String type, boolean isFlowSource) {
        this.namespaceUri = namespaceUri;
        this.type = type;
        this.supportsImplicit = false;
        this.isFlowSource = isFlowSource;
    }

    private PropertiesSourceType(String namespaceUri, String type, boolean supportsImplicit, String implicitPrefix, boolean isFlowSource) {
        this.namespaceUri = namespaceUri;
        this.type = type;
        this.supportsImplicit = supportsImplicit;
        this.implicitPrefix = implicitPrefix;
        this.isFlowSource = isFlowSource;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getType() {
        return this.type;
    }

    public boolean supportsImplicit() {
        return this.supportsImplicit;
    }

    public String getImplicitPrefix() {
        return this.implicitPrefix;
    }

    public boolean isFlowSource() {
        return this.isFlowSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertiesSourceType that = (PropertiesSourceType)o;
        return Objects.equals(this.namespaceUri, that.namespaceUri) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceUri, this.type);
    }

    public String toString() {
        return String.format("%s:%s", this.namespaceUri.substring(this.namespaceUri.lastIndexOf("/") + 1), this.type);
    }

    @Override
    public int compareTo(PropertiesSourceType o) {
        return registeredSourceTypes.indexOf(this) - registeredSourceTypes.indexOf(o);
    }
}

