/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.gateway.steps;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ElementFinder {
    public static Optional<Element> findChildElement(Element root, String childName, Namespace childNamespace, Predicate<? super Element> predicate) {
        return root.getChildren(childName, childNamespace).stream().filter(predicate).findFirst();
    }

    public static Optional<Element> findChildElementWithMatchingAttributeValue(Element root, String childName, Namespace childNamespace, String attributeName, String expectedAttributeValue) {
        return ElementFinder.findChildElement(root, childName, childNamespace, element -> element.getAttributeValue(attributeName) != null && element.getAttributeValue(attributeName).equals(expectedAttributeValue));
    }

    public static boolean containsElementWithMatchingAttributeValue(List<Element> elements, String attributeName, String expectedAttributeValue) {
        return elements.stream().anyMatch(mappingE -> mappingE.getAttributeValue(attributeName).equals(expectedAttributeValue));
    }
}

