/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.gateway.steps.policy.basicstructure;

import com.mulesoft.tools.migration.library.gateway.steps.GatewayNamespaces;
import com.mulesoft.tools.migration.library.gateway.steps.policy.basicstructure.AbstractBasicStructureMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.List;
import org.jdom2.Element;

public class PointcutTagMigrationStep
extends AbstractBasicStructureMigrationStep {
    private static final String POINTCUT_TAG_NAME = "pointcut";
    private static final String API_POINTCUT_TAG_NAME = "api-pointcut";
    private static final String RESOURCE_TAG_NAME = "resource";
    private static final String ENDPOINT_TAG_NAME = "endpoint";
    private static final String APP_TAG_NAME = "app";

    public PointcutTagMigrationStep() {
        super(GatewayNamespaces.MULE_3_POLICY_NAMESPACE, POINTCUT_TAG_NAME);
    }

    public void execute(Element element, MigrationReport migrationReport) throws RuntimeException {
        List children = element.getChildren();
        if (!children.isEmpty()) {
            children.stream().forEach(e -> {
                switch (e.getName()) {
                    case "app": {
                        migrationReport.report("basicStructure.pointcutMigrationStepNoEquivalent", e, e, new String[]{"App"});
                        break;
                    }
                    case "endpoint": {
                        migrationReport.report("basicStructure.pointcutMigrationStepNoEquivalent", e, e, new String[]{"Endpoint"});
                        break;
                    }
                    case "resource": {
                        migrationReport.report("basicStructure.pointcutMigrationStepResolvedByRuntime", e, e, new String[]{"Resource"});
                        break;
                    }
                    case "api-pointcut": {
                        migrationReport.report("basicStructure.pointcutMigrationStepResolvedByRuntime", e, e, new String[]{"Api"});
                        break;
                    }
                    default: {
                        migrationReport.report("basicStructure.pointcutMigrationStepUnknown", e, e, new String[]{"Unknown"});
                    }
                }
            });
        } else {
            migrationReport.report("basicStructure.pointcutMigrationStepUnknown", element, element, new String[]{"Unknown"});
        }
        this.detachContent(element.getContent());
        this.setUpHttpPolicy(element, true, migrationReport);
    }
}

