/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.gateway.steps.policy.threatprotection;

import com.mulesoft.tools.migration.library.gateway.steps.GatewayNamespaces;
import com.mulesoft.tools.migration.library.gateway.steps.policy.threatprotection.AbstractThreatProtectionMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ProtectTagMigrationStep
extends AbstractThreatProtectionMigrationStep {
    private static final String PROTECT = "protect";
    private static final String SECURE_JSON_REQUEST = "secure-json-request";
    private static final String SECURE_XML_REQUEST = "secure-xml-request";
    private static final String THREAT_PROTECTION_POLICY_REF = "threat-protection-policy-ref";
    private static final String ON_UNACCEPTED = "onUnaccepted";
    private static final String CONFIG_REF = "config-ref";
    private static final String CONTENT_TYPE = "contentType";
    private static final String CONTENT_TYPE_VALUE = "#[attributes.headers['content-type']]";

    public ProtectTagMigrationStep() {
        super(GatewayNamespaces.THREAT_PROTECTION_GW_NAMESPACE, PROTECT);
    }

    private void migrateElement(Element element, String tagName, Namespace namespace, String configRefValue) {
        element.setName(tagName);
        element.setNamespace(namespace);
        element.setAttribute(CONFIG_REF, configRefValue);
        element.setAttribute(CONTENT_TYPE, CONTENT_TYPE_VALUE);
        element.removeAttribute(THREAT_PROTECTION_POLICY_REF);
        element.removeAttribute(ON_UNACCEPTED);
    }

    private Boolean isJsonPolicy(Element element, MigrationReport migrationReport) {
        Element root = element.getDocument().getRootElement();
        if (root != null) {
            for (Element e : root.getChildren()) {
                Namespace elementNamespace = e.getNamespace();
                if (elementNamespace.equals((Object)GatewayNamespaces.JSON_THREAT_PROTECTION_NAMESPACE)) {
                    return true;
                }
                if (!elementNamespace.equals((Object)GatewayNamespaces.XML_THREAT_PROTECTION_NAMESPACE)) continue;
                return false;
            }
        }
        migrationReport.report("threatProtection.unknownPolicyType", element, element, new String[0]);
        return null;
    }

    public void execute(Element element, MigrationReport migrationReport) throws RuntimeException {
        Boolean isJsonPolicy = this.isJsonPolicy(element, migrationReport);
        if (isJsonPolicy != null) {
            if (isJsonPolicy.booleanValue()) {
                this.migrateElement(element, SECURE_JSON_REQUEST, GatewayNamespaces.JSON_THREAT_PROTECTION_NAMESPACE, "json-threat-protection-config");
            } else {
                this.migrateElement(element, SECURE_XML_REQUEST, GatewayNamespaces.XML_THREAT_PROTECTION_NAMESPACE, "xml-threat-protection-config");
            }
        }
    }
}

