/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.batch;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class BatchExecute
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = "//*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/batch' and local-name() = 'execute']";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update batch execute to a flow-ref with equal reference name.";
    }

    public BatchExecute() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        object.setNamespace(XmlDslUtils.CORE_NAMESPACE);
        object.setName("flow-ref");
        Attribute expression = object.getAttribute("name");
        if (expression != null) {
            String migratedExpression = this.getExpressionMigrator().migrateExpression(expression.getValue(), true, object);
            expression.setValue(migratedExpression);
        }
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

