/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.compression;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class AbstractCompressionMigrationStep
extends AbstractApplicationModelMigrationStep {
    protected static Namespace COMPRESSION_NAMESPACE = Namespace.getNamespace((String)"compression", (String)"http://www.mulesoft.org/schema/mule/compression");

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        element.setNamespace(COMPRESSION_NAMESPACE);
        element.setName(this.getOperationName());
        element.addContent((Content)this.getStrategyElement(this.getStrategyName()));
        this.transformArguments(element, report);
    }

    protected abstract String getStrategyName();

    protected abstract String getOperationName();

    protected Element getStrategyElement(String name) {
        Element element = new Element(name, COMPRESSION_NAMESPACE);
        element.addContent((Content)new Element("gzip-" + name, COMPRESSION_NAMESPACE));
        return element;
    }

    protected void transformArguments(Element element, MigrationReport report) {
        element.removeAttribute("name");
        this.removeArgumentAndReport(element, "returnClass", "compression.returnClass", report);
        this.removeArgumentAndReport(element, "ignoreBadInput", "compression.ignoreBadInput", report);
    }

    protected void removeArgumentAndReport(Element element, String argumentName, String reportEntryKey, MigrationReport report) {
        Attribute attribute = element.getAttribute(argumentName);
        if (attribute != null) {
            report.report(reportEntryKey, element, element, new String[0]);
            element.removeAttribute(attribute);
        }
    }
}

