/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.category.NamespaceContribution;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Namespace;

public class CleanNamespaces
implements NamespaceContribution {
    private final List<String> nonRemovableNamespaces = Lists.newArrayList((Object[])new String[]{"doc", "xsi"});

    public String getDescription() {
        return "Remove unused namespaces declarations.";
    }

    public void execute(ApplicationModel applicationModel, MigrationReport report) throws RuntimeException {
        List<Document> documents = applicationModel.getApplicationDocuments().values().stream().collect(Collectors.toList());
        documents.forEach(d -> this.removeUnusedNamespacesAndSchemas((Document)d, applicationModel));
    }

    public void removeUnusedNamespacesAndSchemas(Document document, ApplicationModel applicationModel) {
        List<Namespace> unusedNamespaces = document.getRootElement().getAdditionalNamespaces().stream().filter(n -> ApplicationModel.getElementsWithNamespace((Document)document, (Namespace)n, (ApplicationModel)applicationModel).size() <= 0 && !this.nonRemovableNamespaces.contains(n.getPrefix())).collect(Collectors.toList());
        unusedNamespaces.forEach(n -> document.getRootElement().removeNamespaceDeclaration(n));
        Attribute schemaLocationAttribute = document.getRootElement().getAttribute("schemaLocation", document.getRootElement().getNamespace("xsi"));
        HashMap<String, String> schemas = new HashMap<String, String>();
        if (schemaLocationAttribute != null) {
            String[] schemaValue = schemaLocationAttribute.getValue().split("\\s+");
            for (int i = 0; i < schemaValue.length; ++i) {
                if (schemaValue[i].equals("")) continue;
                schemas.put(schemaValue[i], schemaValue[i + 1]);
                ++i;
            }
            unusedNamespaces.forEach(n -> {
                String cfr_ignored_0 = (String)schemas.remove(n.getURI());
            });
            StringBuilder usedSchemas = new StringBuilder();
            schemas.forEach((url, schema) -> {
                usedSchemas.append((String)url);
                usedSchemas.append(" " + schema + " ");
            });
            schemaLocationAttribute.setValue(usedSchemas.toString().trim());
        }
    }
}

