/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.ArrayList;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class MessagePropertiesTransformer
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = XmlDslUtils.getCoreXPathSelector((String)"message-properties-transformer");
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update message-properties-transformer to individual processors.";
    }

    public MessagePropertiesTransformer() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{TransportsUtils.COMPATIBILITY_NAMESPACE}));
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        XmlDslUtils.addCompatibilityNamespace((Document)element.getDocument());
        if (element.getAttribute("scope") == null) {
            report.report("message.outboundProperties", element, element.getParentElement(), new String[0]);
        }
        if ("session".equals(element.getAttributeValue("scope"))) {
            report.report("message.sessionVars", element, element.getParentElement(), new String[0]);
        }
        boolean notOverwrite = false;
        if (element.getAttribute("overwrite") != null && "false".equals(element.getAttributeValue("overwrite"))) {
            notOverwrite = true;
        }
        int index = element.getParent().indexOf((Content)element);
        ArrayList<Element> children = new ArrayList<Element>();
        for (Element child : element.getChildren()) {
            if ("delete-message-property".equals(child.getName())) {
                children.add(child);
                if (element.getAttribute("scope") == null) {
                    child.setNamespace(TransportsUtils.COMPATIBILITY_NAMESPACE);
                    child.setName("remove-property");
                    child.getAttribute("key").setName("propertyName");
                    continue;
                }
                if ("session".equals(element.getAttributeValue("scope"))) {
                    child.setNamespace(TransportsUtils.COMPATIBILITY_NAMESPACE);
                    child.setName("remove-session-variable");
                    child.getAttribute("key").setName("variableName");
                    continue;
                }
                child.setName("remove-variable");
                child.getAttribute("key").setName("variableName");
                continue;
            }
            if ("add-message-property".equals(child.getName())) {
                children.add(child);
                if (element.getAttribute("scope") == null) {
                    if (notOverwrite) {
                        this.setMelExpressionValue(child, child.getAttributeValue("value"), "message.outboundProperties");
                    }
                    child.setNamespace(TransportsUtils.COMPATIBILITY_NAMESPACE);
                    child.setName("set-property");
                    child.getAttribute("key").setName("propertyName");
                    continue;
                }
                if ("session".equals(element.getAttributeValue("scope"))) {
                    if (notOverwrite) {
                        this.setMelExpressionValue(child, child.getAttributeValue("value"), "sessionVars");
                    }
                    child.setNamespace(TransportsUtils.COMPATIBILITY_NAMESPACE);
                    child.setName("set-session-variable");
                    child.getAttribute("key").setName("variableName");
                    continue;
                }
                if (notOverwrite) {
                    String value = child.getAttributeValue("value");
                    String migrated = this.getExpressionMigrator().migrateExpression(value, true, child);
                    if (this.getExpressionMigrator().isWrapped(value) && migrated.startsWith("#[mel:")) {
                        this.setMelExpressionValue(child, value, "vars");
                    } else {
                        child.getAttribute("value").setValue(this.getExpressionMigrator().wrap("vars['" + child.getAttributeValue("key") + "'] default " + (this.getExpressionMigrator().isWrapped(migrated) ? "(" + this.getExpressionMigrator().unwrap(migrated) + ")" : "'" + value + "'")));
                    }
                } else {
                    XmlDslUtils.migrateExpression((Attribute)child.getAttribute("value"), (ExpressionMigrator)this.expressionMigrator);
                }
                child.setName("set-variable");
                child.getAttribute("key").setName("variableName");
                continue;
            }
            if ("rename-message-property".equals(child.getName())) {
                if (element.getAttribute("scope") == null) {
                    child.setNamespace(TransportsUtils.COMPATIBILITY_NAMESPACE);
                    children.add(new Element("set-property", TransportsUtils.COMPATIBILITY_NAMESPACE).setAttribute("propertyName", child.getAttributeValue("value")).setAttribute("value", this.getExpressionMigrator().wrap("mel:message.outboundProperties['" + child.getAttributeValue("key") + "']")));
                    children.add(new Element("remove-property", TransportsUtils.COMPATIBILITY_NAMESPACE).setAttribute("propertyName", child.getAttributeValue("key")));
                    continue;
                }
                if ("session".equals(element.getAttributeValue("scope"))) {
                    child.setNamespace(TransportsUtils.COMPATIBILITY_NAMESPACE);
                    children.add(new Element("set-session-variable", TransportsUtils.COMPATIBILITY_NAMESPACE).setAttribute("variableName", child.getAttributeValue("value")).setAttribute("value", this.getExpressionMigrator().wrap("mel:sessionVars['" + child.getAttributeValue("key") + "']")));
                    children.add(new Element("remove-session-variable", TransportsUtils.COMPATIBILITY_NAMESPACE).setAttribute("variableName", child.getAttributeValue("key")));
                    continue;
                }
                children.add(new Element("set-variable", XmlDslUtils.CORE_NAMESPACE).setAttribute("variableName", child.getAttributeValue("value")).setAttribute("value", this.getExpressionMigrator().wrap("vars['" + child.getAttributeValue("key") + "']")));
                children.add(new Element("remove-variable", XmlDslUtils.CORE_NAMESPACE).setAttribute("variableName", child.getAttributeValue("key")));
                continue;
            }
            if (!"add-message-properties".equals(child.getName())) continue;
            report.report("message.springBeanDefinitionInsideMuleObject", child, element.getParentElement(), new String[0]);
        }
        for (Element child : children) {
            element.removeContent((Content)child);
        }
        element.getParent().addContent(index, children);
        element.detach();
    }

    private void setMelExpressionValue(Element child, String value, String binding) {
        child.getAttribute("value").setValue(this.getExpressionMigrator().wrap("mel:" + binding + "['" + child.getAttributeValue("key") + "'] != null ? " + binding + "['" + child.getAttributeValue("key") + "'] : " + (this.getExpressionMigrator().isWrapped(value) ? this.getExpressionMigrator().unwrap(value) : "'" + value + "'")));
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

