/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.mulesoft.tools.migration.library.mule.steps.core.AbstractExceptionsMigrationStep;
import com.mulesoft.tools.migration.project.model.ApplicationModelUtils;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.ArrayList;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;

public class RollbackExceptionStrategy
extends AbstractExceptionsMigrationStep {
    public static final String XPATH_SELECTOR = XmlDslUtils.getCoreXPathSelector((String)"rollback-exception-strategy");

    public String getDescription() {
        return "Update references to Rollback Exception Strategy.";
    }

    public RollbackExceptionStrategy() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        ApplicationModelUtils.changeNodeName((String)"", (String)"on-error-propagate").apply(element);
        this.encapsulateException(element);
        boolean hadWhen = element.getAttribute("when") != null;
        this.migrateWhenExpression(element);
        if (element.getAttribute("maxRedeliveryAttempts") != null) {
            Attribute maxRedelivery = element.getAttribute("maxRedeliveryAttempts");
            maxRedelivery.detach();
            Element flow = XmlDslUtils.getContainerElement((Element)element);
            if (flow != null && !flow.getChildren().isEmpty()) {
                Element source = (Element)flow.getChildren().get(0);
                if (source.getAttribute("isMessageSource", XmlDslUtils.MIGRATION_NAMESPACE) != null) {
                    Element redelivery = source.getChild("idempotent-redelivery-policy", XmlDslUtils.CORE_NAMESPACE);
                    if (redelivery != null) {
                        redelivery.setName("redelivery-policy");
                        Attribute exprAttr = redelivery.getAttribute("idExpression");
                        exprAttr.setValue(this.getExpressionMigrator().migrateExpression(exprAttr.getValue(), true, redelivery));
                        Attribute maxRedeliveryCountAtt = redelivery.getAttribute("maxRedeliveryCount");
                        if (maxRedeliveryCountAtt != null) {
                            maxRedeliveryCountAtt.setValue(maxRedelivery.getValue());
                        } else {
                            redelivery.setAttribute("maxRedeliveryCount", maxRedelivery.getValue());
                        }
                        if (this.getExpressionMigrator().isWrapped(exprAttr.getValue())) {
                            exprAttr.setValue(this.getExpressionMigrator().wrap(this.getExpressionMigrator().migrateExpression(exprAttr.getValue(), true, element)));
                        }
                        XmlDslUtils.migrateRedeliveryPolicyChildren((Element)redelivery, (MigrationReport)report);
                    } else {
                        Element redeliveryPolicy = new Element("redelivery-policy");
                        redeliveryPolicy.setNamespace(XmlDslUtils.CORE_NAMESPACE);
                        redeliveryPolicy.setAttribute("maxRedeliveryCount", maxRedelivery.getValue());
                        source.addContent(0, (Content)redeliveryPolicy);
                    }
                }
            } else {
                report.report("errorHandling.redelivery", element, element, new String[0]);
            }
        }
        if (element.getChild("on-redelivery-attempts-exceeded", element.getNamespace()) != null) {
            Element redeliverySection = element.getChild("on-redelivery-attempts-exceeded", element.getNamespace());
            redeliverySection.detach();
            Element newOnError = new Element("on-error-propagate");
            newOnError.setNamespace(element.getNamespace());
            newOnError.setAttribute("type", "REDELIVERY_EXHAUSTED");
            ArrayList redeliveryElements = new ArrayList();
            element.getChildren().forEach(e -> redeliveryElements.add(e.clone()));
            redeliverySection.getChildren().forEach(e -> {
                e.detach();
                redeliveryElements.add(e);
            });
            newOnError.addContent(redeliveryElements);
            element.getParentElement().addContent((Content)newOnError);
            if (!hadWhen) {
                element.detach();
            }
        }
    }
}

