/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.project.model.ApplicationModelUtils;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.Optional;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SetProperty
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = "//mule:set-property";
    private static final String SET_VARIABLE = "set-variable";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update Set Property namespace to compatibility.";
    }

    public SetProperty() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{TransportsUtils.COMPATIBILITY_NAMESPACE}));
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        if (this.getApplicationModel().noCompatibilityMode()) {
            String propertyName = element.getAttributeValue("propertyName");
            ApplicationModelUtils.changeNodeName((String)"", (String)SET_VARIABLE).andThen(ApplicationModelUtils.changeAttribute((String)"propertyName", Optional.of("variableName"), Optional.of("outbound_" + propertyName))).apply(element);
            XmlDslUtils.migrateExpression((Attribute)element.getAttribute("value"), (ExpressionMigrator)this.getExpressionMigrator());
        } else {
            XmlDslUtils.migrateExpression((Attribute)element.getAttribute("value"), (ExpressionMigrator)this.getExpressionMigrator());
            XmlDslUtils.addCompatibilityNamespace((Document)element.getDocument());
            report.report("message.outboundProperties", element, element, new String[0]);
            element.setNamespace(TransportsUtils.COMPATIBILITY_NAMESPACE);
        }
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

