/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.mulesoft.tools.migration.exception.MigrationStepException;
import com.mulesoft.tools.migration.project.model.artifact.MuleArtifactJsonModel;
import com.mulesoft.tools.migration.project.model.artifact.MuleArtifactJsonModelUtils;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.category.ProjectStructureContribution;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class SetSecureProperties
implements ProjectStructureContribution {
    public static final String MULE_ARTIFACT_JSON = "mule-artifact.json";
    public static final String SRC_MAIN_RESOURCES_MULE_APP_PROPERTIES = "src/main/resources/mule-app.properties";
    public static final String SECURE_PROPERTIES = "secure.properties";
    public static final String SECURE_PROPERTIES_SEPARATOR = ",";

    public String getDescription() {
        return "Update mule-artifact.json with secureProperties in case they are defined in the mule-app.properties.";
    }

    public void execute(Path projectBasePath, MigrationReport report) throws RuntimeException {
        try {
            List<String> secureProperties = this.resolveSecureProperties(projectBasePath);
            if (!secureProperties.isEmpty()) {
                MuleArtifactJsonModel currentModel = MuleArtifactJsonModelUtils.buildMuleArtifactJson((Path)projectBasePath.resolve(MULE_ARTIFACT_JSON));
                MuleArtifactJsonModel updatedModel = MuleArtifactJsonModelUtils.buildMinimalMuleArtifactJson((String)currentModel.getMinMuleVersion(), secureProperties);
                FileUtils.write((File)projectBasePath.resolve(MULE_ARTIFACT_JSON).toFile(), (CharSequence)updatedModel.toString(), (Charset)MuleArtifactJsonModelUtils.MULE_ARTIFACT_DEFAULT_CHARSET);
            }
        }
        catch (IOException e) {
            throw new MigrationStepException("Could not update secureProperties based on mule-app.properties", (Throwable)e);
        }
    }

    private List<String> resolveSecureProperties(Path projectBasePath) throws IOException {
        List<String> secureProperties;
        block25: {
            File muleAppProperties = new File(projectBasePath.toFile(), SRC_MAIN_RESOURCES_MULE_APP_PROPERTIES);
            secureProperties = new ArrayList<String>();
            if (muleAppProperties != null && muleAppProperties.exists()) {
                try (FileInputStream inputStream = new FileInputStream(muleAppProperties);){
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    String securePropertiesList = properties.getProperty(SECURE_PROPERTIES);
                    if (securePropertiesList == null) break block25;
                    secureProperties = Arrays.stream(securePropertiesList.split(SECURE_PROPERTIES_SEPARATOR)).map(String::trim).collect(Collectors.toList());
                    properties.remove(SECURE_PROPERTIES);
                    try (FileOutputStream outputStream = new FileOutputStream(muleAppProperties);){
                        properties.store(outputStream, null);
                    }
                }
            }
        }
        return secureProperties;
    }
}

