/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core.filter;

import com.mulesoft.tools.migration.library.mule.steps.core.filter.AbstractFilterMigrator;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class IdempotentMessageFilter
extends AbstractFilterMigrator {
    public static final String XPATH_SELECTOR = XmlDslUtils.getCoreXPathSelector((String)"idempotent-message-filter");

    @Override
    public String getDescription() {
        return "Update Idempotent Message Filter to Idempotent-Message Validator.";
    }

    public IdempotentMessageFilter() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    @Override
    public void execute(Element element, MigrationReport report) throws RuntimeException {
        element.setName("idempotent-message-validator");
        this.handleFilter(element);
    }

    @Override
    protected Element resolveValidationHandler(Element errorHandler) {
        return errorHandler.getChildren().stream().filter(c -> "on-error-propagate".equals(c.getName()) && "DUPLICATE_MESSAGE".equals(c.getAttributeValue("type"))).findFirst().orElseGet(() -> {
            Element validationHandler = new Element("on-error-propagate", XmlDslUtils.CORE_NAMESPACE).setAttribute("type", "DUPLICATE_MESSAGE").setAttribute("logException", "false");
            errorHandler.addContent(0, (Content)validationHandler);
            validationHandler.addContent((Content)new Element("set-variable", XmlDslUtils.CORE_NAMESPACE).setAttribute("variableName", "filtered").setAttribute("value", "#[true]"));
            return validationHandler;
        });
    }
}

