/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core.filter;

import com.mulesoft.tools.migration.library.mule.steps.core.filter.AbstractFilterMigrator;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.jdom2.Element;

public class MessageFilterReference
extends AbstractFilterMigrator {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/core' and local-name()='processor' and @ref]";

    @Override
    public String getDescription() {
        return "Update global message-filters.";
    }

    public MessageFilterReference() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    @Override
    public void execute(Element element, MigrationReport report) throws RuntimeException {
        this.getApplicationModel().getNodeOptional("/*/mule:message-filter[@name = '" + element.getAttributeValue("ref") + "']").ifPresent(globalFilter -> {
            globalFilter.setAttribute("globalProcessed", "true", XmlDslUtils.MIGRATION_NAMESPACE);
            Element clonedFilter = globalFilter.clone();
            clonedFilter.removeAttribute("name");
            XmlDslUtils.addElementAfter((Element)clonedFilter, (Element)element);
            element.detach();
        });
    }
}

