/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core.filter;

import com.mulesoft.tools.migration.library.mule.steps.core.filter.AbstractFilterMigrator;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.jdom2.Element;

public class MessagePropertyFilter
extends AbstractFilterMigrator {
    public static final String XPATH_SELECTOR = XmlDslUtils.getCoreXPathSelector((String)"message-property-filter");

    @Override
    public String getDescription() {
        return "Update MessageProperty filter to a validation stub.";
    }

    public MessagePropertyFilter() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    @Override
    public void execute(Element element, MigrationReport report) throws RuntimeException {
        String propertyName;
        this.addValidationsModule(element.getDocument());
        String pattern = element.getAttributeValue("pattern");
        String scope = element.getAttributeValue("scope");
        boolean negated = false;
        int x = pattern.indexOf(":");
        int i = pattern.indexOf(61);
        if (x > -1 && x < i) {
            scope = pattern.substring(0, x);
            pattern = pattern.substring(x + 1);
            i = pattern.indexOf(61);
        }
        if (pattern.charAt(i - 1) == '!') {
            negated = true;
            propertyName = pattern.substring(0, i - 1).trim();
        } else {
            propertyName = pattern.substring(0, i).trim();
        }
        String propertyValue = pattern.substring(i + 1).trim();
        if (propertyValue.contains("*")) {
            if (negated) {
                element.setAttribute("regex", "(?!^" + propertyValue.replaceAll("\\*", ".*") + "$)");
            } else {
                element.setAttribute("regex", "^" + propertyValue.replaceAll("\\*", ".*") + "$");
            }
            element.removeAttribute("pattern");
            element.removeAttribute("scope");
            element.setAttribute("value", "#[vars.compatibility_" + (scope == null ? "outbound" : scope) + "Properties['" + propertyName + "']]");
            element.setName("matches-regex");
            element.setNamespace(VALIDATION_NAMESPACE);
        } else {
            element.setAttribute("expression", "#[vars.compatibility_" + (scope == null ? "outbound" : scope) + "Properties['" + propertyName + "'] " + (negated ? "!=" : "==") + " '" + propertyValue + "']");
            element.removeAttribute("scope");
            element.removeAttribute("pattern");
            element.setName("is-true");
            element.setNamespace(VALIDATION_NAMESPACE);
        }
        this.handleFilter(element);
    }
}

