/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core.properties;

import com.mulesoft.tools.migration.library.mule.steps.core.dw.DataWeaveHelper;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;

public class InboundPropertiesHelper {
    private static final String TMP_INBOUND_PROP_DW_FRAGMENT_SUFFIX = ".dwl_tmp";

    public static void addAttributesMapping(ApplicationModel appModel, String attributesClassName, Map<String, String> expressionsPerProperty, String ... additionalInboundProps) throws IOException {
        if (appModel.noCompatibilityMode()) {
            return;
        }
        File migrationScriptFolder = DataWeaveHelper.getMigrationScriptFolder(appModel.getProjectBasePath());
        migrationScriptFolder.mkdirs();
        try (FileWriter writer = new FileWriter(new File(migrationScriptFolder, attributesClassName + TMP_INBOUND_PROP_DW_FRAGMENT_SUFFIX));){
            writer.write("{" + System.lineSeparator());
            boolean firstLine = true;
            for (Map.Entry<String, String> mapping : expressionsPerProperty.entrySet()) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    writer.write("," + System.lineSeparator());
                }
                writer.write(String.format("    '%s': %s", mapping.getKey(), mapping.getValue()));
            }
            writer.write(System.lineSeparator() + "}" + System.lineSeparator());
            for (String aip : additionalInboundProps) {
                writer.write(" ++ " + aip + System.lineSeparator());
            }
            writer.flush();
        }
    }

    public static void aggregateAttributesMapping(Path basePath) throws IOException {
        File[] listFiles;
        File migrationScriptFolder = DataWeaveHelper.getMigrationScriptFolder(basePath);
        if (!migrationScriptFolder.exists()) {
            return;
        }
        StringBuilder attributes2inboundProperties = new StringBuilder();
        for (File file : listFiles = migrationScriptFolder.listFiles((FilenameFilter)new SuffixFileFilter(TMP_INBOUND_PROP_DW_FRAGMENT_SUFFIX))) {
            attributes2inboundProperties.append(String.format("if (message.attributes.^class == '%s')", StringUtils.substring((String)file.getName(), (int)0, (int)(-1 * TMP_INBOUND_PROP_DW_FRAGMENT_SUFFIX.length()))) + System.lineSeparator());
            attributes2inboundProperties.append(IOUtils.toString((URI)file.toURI(), (Charset)StandardCharsets.UTF_8));
            FileUtils.forceDelete((File)file);
            attributes2inboundProperties.append("else" + System.lineSeparator());
        }
        attributes2inboundProperties.append("{}" + System.lineSeparator());
        DataWeaveHelper.scriptWithHeader(migrationScriptFolder, "attributes2inboundProperties.dwl", "application/java", attributes2inboundProperties.toString());
    }
}

