/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.db;

import com.mulesoft.tools.migration.library.mule.steps.db.DbConfig;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class AbstractDbOperationMigrator
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    private static final Pattern DB_3X_MEL_CONTRIB_PATTERN = Pattern.compile("(?:dbCreateArray|dbCreateStruct)\\(['\\\"]([^'\\\"]*)['\\\"]\\s*,\\s*['\\\"]([^'\\\"]*)['\\\"]\\s*,\\s*(.*)\\)");
    private ExpressionMigrator expressionMigrator;

    protected void migrateInputParamTypes(Element object) {
        List paramTypes = object.getChildren("in-param", DbConfig.DB_NAMESPACE).stream().filter(ip -> ip.getAttribute("type") != null).map(ip -> new Element("parameter-type", DbConfig.DB_NAMESPACE).setAttribute("key", ip.getAttributeValue("name")).setAttribute("type", ip.getAttributeValue("type"))).collect(Collectors.toList());
        if (!paramTypes.isEmpty()) {
            object.addContent((Content)new Element("parameter-types", DbConfig.DB_NAMESPACE).addContent(paramTypes));
        }
    }

    protected void migrateInputParams(Element object) {
        this.doMigrateInputParams(object, Collectors.joining(", ", "#[{", "}]"), "#[{}]", "input-parameters");
    }

    protected void migrateBulkInputParams(Element object) {
        this.doMigrateInputParams(object, Collectors.joining(", ", "#[[{", "}]]"), "#[[{}]]", "bulk-input-parameters");
    }

    private void doMigrateInputParams(Element object, Collector<CharSequence, ?, String> inParamsJoiner, String emptyParamsExpr, String inParamsElementName) {
        LinkedHashMap inputParamsMap = new LinkedHashMap();
        object.getChildren("in-param", DbConfig.DB_NAMESPACE).stream().forEach(ip -> {
            if ("NULL".equals(ip.getAttributeValue("value"))) {
                inputParamsMap.put(ip.getAttributeValue("name"), "null");
            } else {
                String originalValueExpr = ip.getAttributeValue("value");
                Matcher matcher = DB_3X_MEL_CONTRIB_PATTERN.matcher(originalValueExpr);
                while (matcher.find()) {
                    String configName = matcher.group(1);
                    String type = matcher.group(2);
                    String value = matcher.group(3);
                    int openParenthesis = 0;
                    for (int i = 0; i < value.length(); ++i) {
                        if ('(' == value.charAt(i)) {
                            ++openParenthesis;
                        }
                        if (')' == value.charAt(i)) {
                            --openParenthesis;
                        }
                        if (openParenthesis >= 0) continue;
                        originalValueExpr = matcher.replaceFirst(value.substring(0, i - 1));
                        break;
                    }
                    if (openParenthesis >= 0) {
                        originalValueExpr = matcher.replaceFirst(value);
                    }
                    matcher = DB_3X_MEL_CONTRIB_PATTERN.matcher(originalValueExpr);
                }
                String valueExpr = this.getExpressionMigrator().migrateExpression(originalValueExpr, true, ip);
                inputParamsMap.put(ip.getAttributeValue("name"), this.getExpressionMigrator().isWrapped(valueExpr) ? this.getExpressionMigrator().unwrap(valueExpr) : "'" + valueExpr + "'");
            }
        });
        String inputParametersExpr = inputParamsMap.entrySet().stream().map(entry -> String.format("'%s' : %s", entry.getKey(), entry.getValue())).collect(inParamsJoiner);
        for (Element inParam : new ArrayList(object.getChildren("in-param", DbConfig.DB_NAMESPACE))) {
            inParam.detach();
        }
        if (!emptyParamsExpr.equals(inputParametersExpr)) {
            object.addContent((Content)XmlDslUtils.setText((Element)new Element(inParamsElementName, DbConfig.DB_NAMESPACE), (String)inputParametersExpr));
        }
    }

    protected void migrateSql(Element object) {
        object.getChildren("parameterized-query", DbConfig.DB_NAMESPACE).forEach(pq -> {
            pq.setName("sql");
            XmlDslUtils.setText((Element)pq, (String)this.getExpressionMigrator().migrateExpression(pq.getText(), true, pq));
        });
        object.getChildren("dynamic-query", DbConfig.DB_NAMESPACE).forEach(dq -> {
            dq.setName("sql");
            XmlDslUtils.setText((Element)dq, (String)this.getExpressionMigrator().migrateExpression(dq.getText(), true, dq));
        });
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

