/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.db;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class DbConfig
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    private static final String DB_NAMESPACE_PREFIX = "db";
    public static final String DB_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/db";
    public static final Namespace DB_NAMESPACE = Namespace.getNamespace((String)"db", (String)"http://www.mulesoft.org/schema/mule/db");
    public static final String XPATH_SELECTOR = "/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/db']";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update config elements of the DB Connector.";
    }

    public DbConfig() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{DB_NAMESPACE}));
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        if ("template-query".equals(object.getName())) {
            List templateRefs = this.getApplicationModel().getNodes("//*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/db' and local-name() = 'template-query-ref' and @name = '" + object.getAttributeValue("name") + "']");
            for (Element templateRef : new ArrayList(templateRefs)) {
                List migratedChildren = object.cloneContent();
                for (Content migratedChild : migratedChildren) {
                    Element migratedChildElement;
                    if (Content.CType.Element != migratedChild.getCType() || !"in-param".equals(((Element)migratedChild).getName()) || (migratedChildElement = (Element)migratedChild).getAttribute("defaultValue") == null) continue;
                    migratedChildElement.getAttribute("defaultValue").setName("value");
                }
                templateRef.getParent().addContent(templateRef.getParent().indexOf((Content)templateRef), (Collection)migratedChildren);
                templateRef.detach();
            }
            object.detach();
            return;
        }
        Element dataTypes = object.getChild("data-types", DB_NAMESPACE);
        if (dataTypes != null) {
            dataTypes.setName("column-types");
            for (Element dataType : dataTypes.getChildren("data-type", DB_NAMESPACE)) {
                dataType.setName("column-type");
                dataType.getAttribute("name").setName("typeName");
            }
        }
        Element connection = null;
        if (object.getAttribute("dataSource-ref") != null) {
            report.report("db.referencedDataSource", object, object, new String[]{object.getName()});
            connection = new Element("data-source-connection", DB_NAMESPACE);
            object.addContent((Content)connection);
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"dataSource-ref", (String)"dataSourceRef");
            List otherAttributes = object.getAttributes().stream().filter(att -> !"name".equals(att.getName())).collect(Collectors.toList());
            if (!otherAttributes.isEmpty()) {
                report.report("db.configAttributesOverlap", connection, connection, new String[]{otherAttributes.toString()});
            }
        } else if (object.getAttribute("url") != null) {
            connection = new Element("generic-connection", DB_NAMESPACE);
            object.addContent((Content)connection);
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"user");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"password");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"url");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"useXaTransactions");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"transactionIsolation");
            if (!XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"driverClassName")) {
                if ("derby-config".equals(object.getName())) {
                    connection.setAttribute("driverClassName", "org.apache.derby.jdbc.EmbeddedDriver");
                } else if ("mysql-config".equals(object.getName())) {
                    connection.setAttribute("driverClassName", "com.mysql.jdbc.Driver");
                    report.report("db.jdbcDriverDependency", connection, connection, new String[0]);
                } else if ("oracle-config".equals(object.getName())) {
                    connection.setAttribute("driverClassName", "oracle.jdbc.driver.OracleDriver");
                    report.report("db.jdbcDriverDependency", connection, connection, new String[0]);
                } else {
                    report.report("db.jdbcDriverDependency", connection, connection, new String[0]);
                }
            }
            report.report("db.jdbcUrlForSpecificEngine", connection, connection, new String[0]);
            Element connectionProps = object.getChild("connection-properties", DB_NAMESPACE);
            if (connectionProps != null) {
                Optional<Element> userProp = connectionProps.getChildren("property", DB_NAMESPACE).stream().filter(p -> "user".equals(p.getAttributeValue("key"))).findFirst();
                if (userProp.isPresent()) {
                    connection.setAttribute("user", userProp.get().getAttributeValue("value"));
                    connectionProps.removeContent((Content)userProp.get());
                }
                if (connectionProps.getChildren().isEmpty()) {
                    object.removeContent((Content)connectionProps);
                }
            }
        } else if ("derby-config".equals(object.getName())) {
            connection = new Element("derby-connection", DB_NAMESPACE);
            object.addContent((Content)connection);
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"user");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"password");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"useXaTransactions");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"transactionIsolation");
        } else if ("mysql-config".equals(object.getName())) {
            connection = new Element("my-sql-connection", DB_NAMESPACE);
            object.addContent((Content)connection);
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"database");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"host");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"port");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"user");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"password");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"useXaTransactions");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"transactionIsolation");
            report.report("db.jdbcDriverDependency", connection, connection, new String[0]);
        } else if ("oracle-config".equals(object.getName())) {
            connection = new Element("oracle-connection", DB_NAMESPACE);
            object.addContent((Content)connection);
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"host");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"port");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"instance");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"user");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"password");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"useXaTransactions");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"transactionIsolation");
            report.report("db.jdbcDriverDependency", connection, connection, new String[0]);
        }
        XmlDslUtils.migrateReconnection((Element)connection, (Element)object, (MigrationReport)report);
        ArrayList configChildren = new ArrayList(object.getChildren());
        Collections.reverse(configChildren);
        for (Element element : configChildren) {
            if (element == connection) continue;
            element.detach();
            if ("reconnect-forever".equals(element.getName()) || "reconnect".equals(element.getName())) continue;
            connection.addContent(0, (Content)element);
        }
        object.setName("config");
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

