/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.db;

import com.mulesoft.tools.migration.library.mule.steps.db.AbstractDbOperationMigrator;
import com.mulesoft.tools.migration.library.mule.steps.db.DbConfig;
import com.mulesoft.tools.migration.library.tools.mel.DefaultMelCompatibilityResolver;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.CompatibilityResolver;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import org.jdom2.Content;
import org.jdom2.Element;

public class DbInsert
extends AbstractDbOperationMigrator {
    public static final String XPATH_SELECTOR = "//*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/db' and local-name() = 'insert']";

    public String getDescription() {
        return "Update insert operation of the DB Connector.";
    }

    public DbInsert() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        this.migrateSql(object);
        if ("true".equals(object.getAttributeValue("bulkMode"))) {
            object.setName("bulk-insert");
            object.removeAttribute("bulkMode");
            this.migrateBulkInputParams(object);
        } else {
            this.migrateInputParamTypes(object);
            this.migrateInputParams(object);
        }
        if (object.getAttribute("autoGeneratedKeysColumnIndexes") != null) {
            object.addContent((Content)new Element("auto-generated-keys-column-indexes", DbConfig.DB_NAMESPACE).addContent((Content)new Element("auto-generated-keys-column-index", DbConfig.DB_NAMESPACE).setAttribute("value", object.getAttributeValue("autoGeneratedKeysColumnIndexes"))));
            object.removeAttribute("autoGeneratedKeysColumnIndexes");
        }
        if (object.getAttribute("autoGeneratedKeysColumnNames") != null) {
            object.addContent((Content)new Element("auto-generated-keys-column-names", DbConfig.DB_NAMESPACE).addContent((Content)new Element("auto-generated-keys-column-name", DbConfig.DB_NAMESPACE).setAttribute("value", object.getAttributeValue("autoGeneratedKeysColumnNames"))));
            object.removeAttribute("autoGeneratedKeysColumnNames");
        }
        if (object.getAttribute("source") != null) {
            report.report("db.source", object, object, new String[0]);
            object.removeAttribute("source");
        }
        XmlDslUtils.migrateOperationStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report, (boolean)false, (ExpressionMigrator)this.getExpressionMigrator(), (CompatibilityResolver)new DefaultMelCompatibilityResolver());
    }
}

