/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.endpoint;

import com.mulesoft.tools.migration.library.mule.steps.email.SmtpOutboundEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.email.SmtpsOutboundEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.file.FileOutboundEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.ftp.FtpEeOutboundEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.http.HttpOutboundEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.http.HttpsOutboundEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.jms.JmsOutboundEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.sftp.SftpOutboundEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.vm.VmOutboundEndpoint;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class OutboundEndpoint
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    private static final String HTTP_NS_PREFIX = "http";
    private static final String HTTP_NS_URI = "http://www.mulesoft.org/schema/mule/http";
    private static final String FILE_NS_PREFIX = "file";
    private static final String FILE_NS_URI = "http://www.mulesoft.org/schema/mule/file";
    private static final String FTP_NS_PREFIX = "ftp";
    private static final String FTP_NS_URI = "http://www.mulesoft.org/schema/mule/ee/ftp";
    private static final String SFTP_NS_PREFIX = "sftp";
    private static final String SFTP_NS_URI = "http://www.mulesoft.org/schema/mule/sftp";
    private static final String JMS_NS_PREFIX = "jms";
    private static final String JMS_NS_URI = "http://www.mulesoft.org/schema/mule/jms";
    private static final String VM_NS_PREFIX = "vm";
    private static final String VM_NS_URI = "http://www.mulesoft.org/schema/mule/vm";
    public static final String XPATH_SELECTOR = "//mule:outbound-endpoint";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update generic outbound endpoints.";
    }

    public OutboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        object.getChildren("property", XmlDslUtils.CORE_NAMESPACE).forEach(p -> object.setAttribute(p.getAttributeValue("key"), p.getAttributeValue("value")));
        object.removeChildren("property", XmlDslUtils.CORE_NAMESPACE);
        if (object.getAttribute("address") != null) {
            String address = object.getAttributeValue("address");
            AbstractApplicationModelMigrationStep migrator = null;
            if (address.startsWith("file://")) {
                migrator = new FileOutboundEndpoint();
                object.setNamespace(Namespace.getNamespace((String)FILE_NS_PREFIX, (String)FILE_NS_URI));
            } else if (address.startsWith("ftp://")) {
                migrator = new FtpEeOutboundEndpoint();
                object.setNamespace(Namespace.getNamespace((String)FTP_NS_PREFIX, (String)FTP_NS_URI));
            } else if (address.startsWith("sftp://")) {
                migrator = new SftpOutboundEndpoint();
                object.setNamespace(Namespace.getNamespace((String)SFTP_NS_PREFIX, (String)SFTP_NS_URI));
            } else if (address.startsWith("http://")) {
                migrator = new HttpOutboundEndpoint();
                object.setNamespace(Namespace.getNamespace((String)HTTP_NS_PREFIX, (String)HTTP_NS_URI));
            } else if (address.startsWith("https://")) {
                migrator = new HttpsOutboundEndpoint();
                object.setNamespace(Namespace.getNamespace((String)"https", (String)"http://www.mulesoft.org/schema/mule/https"));
            } else if (address.startsWith("smtp://")) {
                migrator = new SmtpOutboundEndpoint();
                object.setNamespace(Namespace.getNamespace((String)"smtp", (String)"http://www.mulesoft.org/schema/mule/smtp"));
            } else if (address.startsWith("smtps://")) {
                migrator = new SmtpsOutboundEndpoint();
                object.setNamespace(Namespace.getNamespace((String)"smtps", (String)"http://www.mulesoft.org/schema/mule/smtps"));
            } else if (address.startsWith("jms://")) {
                migrator = new JmsOutboundEndpoint();
                object.setNamespace(Namespace.getNamespace((String)JMS_NS_PREFIX, (String)JMS_NS_URI));
            } else if (address.startsWith("vm://")) {
                migrator = new VmOutboundEndpoint();
                object.setNamespace(Namespace.getNamespace((String)VM_NS_PREFIX, (String)VM_NS_URI));
            }
            if (migrator != null) {
                migrator.setApplicationModel(this.getApplicationModel());
                if (migrator instanceof ExpressionMigratorAware) {
                    ((ExpressionMigratorAware)migrator).setExpressionMigrator(this.getExpressionMigrator());
                }
                migrator.execute(object, report);
            }
            object.removeAttribute("address");
        }
        if (object.getAttribute("exchange-pattern") != null) {
            object.removeAttribute("exchange-pattern");
        }
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

