/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.file;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class FileConfig
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    private static final String FILE_NAMESPACE_PREFIX = "file";
    public static final String FILE_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/file";
    public static final Namespace FILE_NAMESPACE = Namespace.getNamespace((String)"file", (String)"http://www.mulesoft.org/schema/mule/file");
    public static final String XPATH_SELECTOR = "/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/file' and local-name()='connector']";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update File connector config.";
    }

    public FileConfig() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{FILE_NAMESPACE}));
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        TransportsUtils.handleServiceOverrides((Element)object, (MigrationReport)report);
        this.handleInputImplicitConnectorRef(object, report);
        this.handleOutputImplicitConnectorRef(object, report);
        object.setName("config");
        Element connection = new Element("connection", FILE_NAMESPACE);
        connection.setAttribute("workingDir", ".");
        object.addContent((Content)connection);
        if (object.getAttribute("streaming") != null && !"true".equals(object.getAttributeValue("streaming"))) {
            report.report("file.streaming", object, object, new String[0]);
        }
        object.removeAttribute("streaming");
        if (object.getAttribute("serialiseObjects") != null && !"false".equals(object.getAttributeValue("serializeObjects"))) {
            report.report("file.serialiseObjects", object, object, new String[0]);
        }
        object.removeAttribute("serialiseObjects");
        if (object.getAttribute("workDirectory") != null) {
            report.report("file.workDirectory", object, object, new String[0]);
        }
        object.removeAttribute("workDirectory");
        if (object.getAttribute("workFileNamePattern") != null) {
            report.report("file.workFileNamePattern", object, object, new String[0]);
        }
        object.removeAttribute("workFileNamePattern");
        XmlDslUtils.migrateReconnection((Element)connection, (Element)object, (MigrationReport)report);
        Element matcher = new Element("matcher", FILE_NAMESPACE_URI);
        matcher.setAttribute("name", object.getAttributeValue("name") + "Matcher");
        boolean matcherUsed = false;
        String fileAge = null;
        if (object.getAttribute("fileAge") != null) {
            fileAge = object.getAttributeValue("fileAge");
            object.removeAttribute("fileAge");
        }
        FileConfig.handleChildElements(object, connection, report);
        this.handleInputSpecificAttributes(object, matcherUsed, fileAge, report);
        this.handleOutputSpecificAttributes(object, report);
    }

    private void handleInputImplicitConnectorRef(Element object, MigrationReport report) {
        this.makeImplicitConnectorRefsExplicit(object, report, this.getApplicationModel().getNodes("/*/mule:flow/*[namespace-uri()='http://www.mulesoft.org/schema/mule/file' and local-name()='inbound-endpoint' and not(@connector-ref)]"));
        this.makeImplicitConnectorRefsExplicit(object, report, this.getApplicationModel().getNodes("//mule:inbound-endpoint[not(@connector-ref) and starts-with(@address, 'file://')]"));
    }

    private void handleOutputImplicitConnectorRef(Element object, MigrationReport report) {
        this.makeImplicitConnectorRefsExplicit(object, report, this.getApplicationModel().getNodes("//*[namespace-uri()='http://www.mulesoft.org/schema/mule/file' and local-name()='outbound-endpoint' and not(@connector-ref)]"));
        this.makeImplicitConnectorRefsExplicit(object, report, this.getApplicationModel().getNodes("//mule:outbound-endpoint[not(@connector-ref) and starts-with(@address, 'file://')]"));
    }

    private void makeImplicitConnectorRefsExplicit(Element object, MigrationReport report, List<Element> implicitConnectorRefs) {
        List availableConfigs = this.getApplicationModel().getNodes("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/file' and local-name()='config']");
        if (implicitConnectorRefs.size() > 0 && availableConfigs.size() > 1) {
            for (Element implicitConnectorRef : implicitConnectorRefs) {
                report.report("transports.manyConnectors", implicitConnectorRef, implicitConnectorRef, new String[]{FILE_NAMESPACE_PREFIX, availableConfigs.stream().map(e -> e.getAttributeValue("name")).collect(Collectors.joining(", "))});
            }
        } else {
            for (Element implicitConnectorRef : implicitConnectorRefs) {
                implicitConnectorRef.setAttribute("connector-ref", object.getAttributeValue("name"));
            }
        }
    }

    public static void handleChildElements(Element object, Element connection, MigrationReport report) {
        TransportsUtils.handleConnectorChildElements((Element)object, (Element)object, (Element)connection, (MigrationReport)report);
        Element customFileNameParser = object.getChild("custom-filename-parser", FILE_NAMESPACE);
        if (customFileNameParser != null) {
            report.report("file.filePath", customFileNameParser, object, new String[0]);
            object.removeContent((Content)customFileNameParser);
        }
        object.removeContent((Content)object.getChild("expression-filename-parser", FILE_NAMESPACE));
    }

    private void handleInputSpecificAttributes(Element object, boolean matcherUsed, String fileAge, MigrationReport report) {
        Stream.concat(this.getApplicationModel().getNodes("//*[namespace-uri()='http://www.mulesoft.org/schema/mule/file' and local-name()='inbound-endpoint' and @connector-ref='" + object.getAttributeValue("name") + "']").stream(), this.getApplicationModel().getNodes("//mule:inbound-endpoint[@connector-ref='" + object.getAttributeValue("name") + "']").stream()).forEach(e -> this.passConnectorConfigToInboundEnpoint(object, matcherUsed, fileAge, (Element)e));
        object.removeAttribute("pollingFrequency");
        object.removeAttribute("readFromDirectory");
        object.removeAttribute("autoDelete");
        object.removeAttribute("recursive");
        object.removeAttribute("moveToDirectory");
        object.removeAttribute("moveToPattern");
    }

    private void handleOutputSpecificAttributes(Element object, MigrationReport report) {
        Stream.concat(this.getApplicationModel().getNodes("//*[namespace-uri()='http://www.mulesoft.org/schema/mule/file' and local-name()='outbound-endpoint' and @connector-ref='" + object.getAttributeValue("name") + "']").stream(), this.getApplicationModel().getNodes("//mule:outbound-endpoint[@connector-ref='" + object.getAttributeValue("name") + "']").stream()).forEach(e -> this.passConnectorConfigToOutboundEndpoint(object, (Element)e));
        object.removeAttribute("writeToDirectory");
        object.removeAttribute("outputPattern");
        object.removeAttribute("outputAppend");
    }

    private void passConnectorConfigToInboundEnpoint(Element object, boolean matcherUsed, String fileAge, Element listener) {
        String recursive;
        String autoDelete;
        Element schedulingStr = new Element("scheduling-strategy", XmlDslUtils.CORE_NAMESPACE);
        listener.addContent((Content)schedulingStr);
        Element fixedFrequency = new Element("fixed-frequency", XmlDslUtils.CORE_NAMESPACE);
        fixedFrequency.setAttribute("frequency", object.getAttributeValue("pollingFrequency", "1000"));
        schedulingStr.addContent((Content)fixedFrequency);
        if (object.getAttribute("readFromDirectory") != null) {
            listener.setAttribute("directory", object.getAttributeValue("readFromDirectory"));
        }
        if (fileAge != null && !"0".equals(fileAge)) {
            listener.setAttribute("timeBetweenSizeCheck", fileAge);
        }
        if ((autoDelete = XmlDslUtils.changeDefault((String)"true", (String)"false", (String)object.getAttributeValue("autoDelete"))) != null) {
            listener.setAttribute("autoDelete", autoDelete);
        }
        listener.setAttribute("recursive", (recursive = XmlDslUtils.changeDefault((String)"false", (String)"true", (String)object.getAttributeValue("recursive"))) != null ? recursive : "true");
        if (object.getAttribute("moveToDirectory") != null && listener.getAttribute("moveToDirectory") == null) {
            listener.setAttribute("moveToDirectory", object.getAttributeValue("moveToDirectory"));
        }
        if (object.getAttribute("moveToPattern") != null) {
            String moveToPattern = object.getAttributeValue("moveToPattern");
            listener.setAttribute("renameTo", this.getExpressionMigrator().migrateExpression(moveToPattern, true, listener));
        }
        if (matcherUsed) {
            listener.setAttribute("matcher", object.getAttributeValue("name") + "Matcher");
        }
    }

    private void passConnectorConfigToOutboundEndpoint(Element object, Element write) {
        if (object.getAttribute("writeToDirectory") != null) {
            write.setAttribute("writeToDirectory", object.getAttributeValue("writeToDirectory"));
        }
        if (object.getAttribute("outputPattern") != null) {
            write.setAttribute("outputPatternConfig", object.getAttributeValue("outputPattern"));
        }
        if (object.getAttribute("outputAppend") != null && !"false".equals(object.getAttributeValue("outputAppend"))) {
            write.setAttribute("mode", "APPEND");
        }
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

