/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.file;

import com.mulesoft.tools.migration.library.mule.steps.core.dw.DataWeaveHelper;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.io.IOException;
import org.jdom2.Element;

public class FileOutboundEndpoint
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/file' and local-name()='outbound-endpoint']";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update File outbound endpoints.";
    }

    public FileOutboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        object.setName("write");
        TransportsUtils.extractInboundChildren((Element)object, (ApplicationModel)this.getApplicationModel());
        XmlDslUtils.migrateOperationStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report);
        object.setAttribute("path", this.outputFileLib("{ writeToDirectory: " + (object.getAttribute("path") == null ? this.propToDwExpr(object, "writeToDirectory") : "'" + object.getAttributeValue("path") + "'") + ", address: " + (object.getAttribute("address") != null ? "'" + object.getAttributeValue("address").substring("file://".length()) + "'" : "null") + ", outputPattern: " + this.propToDwExpr(object, "outputPattern") + ", outputPatternConfig: " + this.getExpressionMigrator().unwrap(this.propToDwExpr(object, "outputPatternConfig")) + "}"));
        if (object.getAttribute("connector-ref") != null) {
            object.getAttribute("connector-ref").setName("config-ref");
        }
        if (object.getAttribute("outputAppend") != null && !"false".equals(object.getAttributeValue("outputAppend"))) {
            object.setAttribute("mode", "APPEND");
        }
        object.removeAttribute("writeToDirectory");
        object.removeAttribute("outputPattern");
        object.removeAttribute("outputPatternConfig");
        object.removeAttribute("outputAppend");
        if (object.getAttribute("name") != null) {
            object.removeAttribute("name");
        }
        if (object.getAttribute("exchange-pattern") != null) {
            object.removeAttribute("exchange-pattern");
        }
    }

    private String outputFileLib(String pathDslParams) {
        try {
            String varPrefix = this.getApplicationModel().noCompatibilityMode() ? "vars.outbound_" : "vars.compatibility_outboundProperties.";
            String varFilename = this.getApplicationModel().noCompatibilityMode() ? "message.attributes.fileName" : "vars.compatibility_inboundProperties.filename";
            DataWeaveHelper.library(DataWeaveHelper.getMigrationScriptFolder(this.getApplicationModel().getProjectBasePath()), "FileWriteOutputFile.dwl", "/**" + System.lineSeparator() + " * Emulates the outbound endpoint logic for determining the output filename of the Mule 3.x File transport." + System.lineSeparator() + " */" + System.lineSeparator() + "fun fileWriteOutputfile(vars: {}, pathDslParams: {}) = do {" + System.lineSeparator() + "    ((" + varPrefix + "writeToDirectoryName" + System.lineSeparator() + "        default pathDslParams.writeToDirectory)" + System.lineSeparator() + "        default pathDslParams.address)" + System.lineSeparator() + "    ++ '/' ++" + System.lineSeparator() + "    ((((pathDslParams.outputPattern" + System.lineSeparator() + "        default " + varPrefix + "outputPattern)" + System.lineSeparator() + "        default pathDslParams.outputPatternConfig)" + System.lineSeparator() + "        default " + varFilename + ")" + System.lineSeparator() + "        default (uuid() ++ '.dat'))" + System.lineSeparator() + "}" + System.lineSeparator() + System.lineSeparator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return "#[migration::FileWriteOutputFile::fileWriteOutputfile(vars, " + pathDslParams + ")]";
    }

    private String propToDwExpr(Element object, String propName) {
        if (object.getAttribute(propName) != null) {
            if (this.getExpressionMigrator().isTemplate(object.getAttributeValue(propName))) {
                return this.getExpressionMigrator().unwrap(this.getExpressionMigrator().migrateExpression(object.getAttributeValue(propName), true, object));
            }
            return "'" + object.getAttributeValue(propName) + "'";
        }
        return "null";
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

