/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.ftp;

import com.mulesoft.tools.migration.library.mule.steps.core.dw.DataWeaveHelper;
import com.mulesoft.tools.migration.library.mule.steps.ftp.AbstractFtpEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.ftp.FtpConfig;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.io.IOException;
import java.util.Optional;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class FtpOutboundEndpoint
extends AbstractFtpEndpoint {
    public static final String XPATH_SELECTOR = "//*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/ftp' and local-name() = 'outbound-endpoint']";

    public String getDescription() {
        return "Update FTP outbound endpoints.";
    }

    public FtpOutboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        object.setName("write");
        object.setNamespace(FtpConfig.FTP_NAMESPACE);
        String configName = object.getAttributeValue("connector-ref");
        Optional config = configName != null ? this.getApplicationModel().getNodeOptional("/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/ftp' and local-name() = 'config' and @name = '" + configName + "']") : this.getApplicationModel().getNodeOptional("/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/ftp' and local-name() = 'config']");
        Element ftpConfig = this.migrateFtpConfig(object, config, configName, config, report);
        Element connection = ftpConfig.getChild("connection", FtpConfig.FTP_NAMESPACE);
        TransportsUtils.processAddress((Element)object, (MigrationReport)report).ifPresent(address -> {
            connection.setAttribute("host", address.getHost());
            connection.setAttribute("port", address.getPort());
            if (address.getCredentials() != null) {
                String[] credsSplit = address.getCredentials().split(":");
                connection.setAttribute("username", credsSplit[0]);
                connection.setAttribute("password", credsSplit[1]);
            }
            object.setAttribute("path", address.getPath() != null ? address.getPath() : "/");
        });
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"host");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"port");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"user", (String)"username");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"password");
        Attribute pathAttr = object.getAttribute("path");
        if (pathAttr != null) {
            pathAttr.setValue(this.resolveDirectory(pathAttr.getValue()));
        }
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"path", (String)"workingDir");
        if (object.getAttribute("connector-ref") != null) {
            object.getAttribute("connector-ref").setName("config-ref");
        } else {
            object.setAttribute("config-ref", ftpConfig.getAttributeValue("name"));
        }
        object.removeAttribute("name");
        if (object.getAttribute("responseTimeout") != null) {
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"responseTimeout", (String)"connectionTimeout");
            connection.setAttribute("connectionTimeoutUnit", "MILLISECONDS");
        }
        TransportsUtils.extractInboundChildren((Element)object, (ApplicationModel)this.getApplicationModel());
        XmlDslUtils.migrateOperationStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report);
        object.setAttribute("path", this.outputFileLib("{ outputPattern: " + this.propToDwExpr(object, "outputPattern") + ", outputPatternConfig: " + this.getExpressionMigrator().unwrap(this.propToDwExpr(object, "outputPatternConfig")) + "}"));
        if (object.getAttribute("exchange-pattern") != null) {
            object.removeAttribute("exchange-pattern");
        }
    }

    private String outputFileLib(String pathDslParams) {
        try {
            String varPrefix = this.getApplicationModel().noCompatibilityMode() ? "vars.outbound_" : "vars.compatibility_outboundProperties.";
            DataWeaveHelper.library(DataWeaveHelper.getMigrationScriptFolder(this.getApplicationModel().getProjectBasePath()), "FtpWriteOutputFile.dwl", "/**" + System.lineSeparator() + " * Emulates the outbound endpoint logic for determining the output filename of the Mule 3.x Ftp transport." + System.lineSeparator() + " */" + System.lineSeparator() + "fun ftpWriteOutputfile(vars: {}, pathDslParams: {}) = do {" + System.lineSeparator() + "    ((((" + varPrefix + "filename" + System.lineSeparator() + "        default pathDslParams.outputPattern)" + System.lineSeparator() + "        default " + varPrefix + "outputPattern)" + System.lineSeparator() + "        default pathDslParams.outputPatternConfig)" + System.lineSeparator() + "        default (uuid() ++ '.dat'))" + System.lineSeparator() + "}" + System.lineSeparator() + System.lineSeparator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return "#[migration::FtpWriteOutputFile::ftpWriteOutputfile(vars, " + pathDslParams + ")]";
    }

    private String propToDwExpr(Element object, String propName) {
        if (object.getAttribute(propName) != null) {
            if (this.getExpressionMigrator().isTemplate(object.getAttributeValue(propName))) {
                return this.getExpressionMigrator().unwrap(this.getExpressionMigrator().migrateExpression(object.getAttributeValue(propName), true, object));
            }
            return "'" + object.getAttributeValue(propName) + "'";
        }
        return "null";
    }
}

