/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.http;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class AbstractHttpConnectorMigrationStep
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String HTTP_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/http";
    public static final Namespace HTTP_NAMESPACE = Namespace.getNamespace((String)"http", (String)"http://www.mulesoft.org/schema/mule/http");
    public static final String HTTPS_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/https";
    public static final Namespace HTTPS_NAMESPACE = Namespace.getNamespace((String)"https", (String)"http://www.mulesoft.org/schema/mule/https");
    public static final String TLS_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/tls";
    protected static final String TLS_NAMESPACE_PREFIX = "tls";
    public static final Namespace TLS_NAMESPACE = Namespace.getNamespace((String)"tls", (String)"http://www.mulesoft.org/schema/mule/tls");
    private ExpressionMigrator expressionMigrator;

    protected void setMule4MapBuilderTagText(int idx, String tagName, Element parentTag, Namespace httpNamespace, MigrationReport report, Supplier<String> paramsExprCreate, Function<String, String> paramsExprAppend) {
        Element mule4MapBuilderTag = this.lookupMule4MapBuilderTag(idx, tagName, parentTag, httpNamespace, report);
        XmlDslUtils.setText((Element)mule4MapBuilderTag, (String)this.getExpressionMigrator().wrap(StringUtils.isEmpty((CharSequence)mule4MapBuilderTag.getText()) ? paramsExprCreate.get() : paramsExprAppend.apply(mule4MapBuilderTag.getText())));
    }

    private Element lookupMule4MapBuilderTag(int idx, String tagName, Element parentTag, Namespace httpNamespace, MigrationReport report) {
        List children = parentTag.getChildren(tagName, httpNamespace);
        return children.stream().filter(c -> this.doesNotRequireMapExpression((Element)c)).findAny().orElseGet(() -> {
            Element mapBuilderElement = new Element(tagName, httpNamespace);
            parentTag.addContent(idx, (Content)mapBuilderElement);
            report.report("http.mapExpression", mapBuilderElement, parentTag, new String[]{tagName});
            return mapBuilderElement;
        });
    }

    private boolean doesNotRequireMapExpression(Element c) {
        return StringUtils.isNotEmpty((CharSequence)c.getTextTrim()) || c.getAttributeValue("expression") == null;
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

