/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.http;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.http.AbstractHttpConnectorMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.ArrayList;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class HttpConnectorRequestConfig
extends AbstractHttpConnectorMigrationStep {
    private static final String TCP_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/tcp";
    private static final String TCP_NAMESPACE_PREFIX = "tcp";
    private static final Namespace TCP_NAMESPACE = Namespace.getNamespace((String)"tcp", (String)"http://www.mulesoft.org/schema/mule/tcp");
    public static final String XPATH_SELECTOR = "/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and ( local-name()='request-config' or local-name()='proxy' or local-name()='ntlm-proxy')]";

    public String getDescription() {
        return "Update HTTP Connector request config.";
    }

    public HttpConnectorRequestConfig() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{TLS_NAMESPACE, TCP_NAMESPACE}));
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        object.setNamespace(HTTP_NAMESPACE);
        if ("request-config".equals(object.getName())) {
            Element requestConnection = new Element("request-connection", HTTP_NAMESPACE);
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)requestConnection, (String)"protocol");
            this.copyExpressionAttributeIfPresent(object, requestConnection, "host", "host", true);
            this.copyExpressionAttributeIfPresent(object, requestConnection, "port", "port", true);
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)requestConnection, (String)"usePersistentConnections");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)requestConnection, (String)"maxConnections");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)requestConnection, (String)"connectionIdleTimeout");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)requestConnection, (String)"streamResponse");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)requestConnection, (String)"responseBufferSize");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)requestConnection, (String)"tlsContext-ref", (String)"tlsContext");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)requestConnection, (String)"clientSocketProperties-ref", (String)"clientSocketProperties");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)requestConnection, (String)"proxy-ref", (String)"proxyConfig");
            object.addContent((Content)requestConnection);
            for (Attribute attribute : object.getAttributes()) {
                if (!"basePath".equals(attribute.getName()) && !"followRedirects".equals(attribute.getName()) && !"sendBodyMode".equals(attribute.getName()) && !"requestStreamingMode".equals(attribute.getName()) && !"responseTimeout".equals(attribute.getName())) continue;
                attribute.setValue(this.getExpressionMigrator().migrateExpression(attribute.getValue(), true, object));
            }
        }
        new ArrayList<Element>(object.getChildren()).forEach(c -> {
            if ("http://www.mulesoft.org/schema/mule/http".equals(c.getNamespaceURI())) {
                this.migrateHttpChild((Element)c, report);
            } else if ("http://www.mulesoft.org/schema/mule/tls".equals(c.getNamespaceURI()) && "context".equals(c.getName())) {
                Element requestConnection = c.getParentElement().getChild("request-connection", HTTP_NAMESPACE);
                c.detach();
                requestConnection.addContent((Content)c);
            } else if (TCP_NAMESPACE_URI.equals(c.getNamespaceURI()) && "client-socket-properties".equals(c.getName())) {
                Element clientSocketPropsContainer = new Element("client-socket-properties", HTTP_NAMESPACE);
                Element requestConnection = c.getParentElement().getChild("request-connection", HTTP_NAMESPACE);
                c.detach();
                clientSocketPropsContainer.addContent((Content)c);
                requestConnection.addContent((Content)clientSocketPropsContainer);
            }
        });
    }

    private void migrateHttpChild(Element object, MigrationReport report) {
        Element requestConnection;
        if ("basic-authentication".equals(object.getName()) || "digest-authentication".equals(object.getName()) || "ntlm-authentication".equals(object.getName())) {
            Element authentication = new Element("authentication", HTTP_NAMESPACE);
            requestConnection = object.getParentElement().getChild("request-connection", HTTP_NAMESPACE);
            object.detach();
            authentication.addContent((Content)object);
            requestConnection.addContent((Content)authentication);
            for (Attribute attribute : object.getAttributes()) {
                XmlDslUtils.migrateExpression((Attribute)attribute, (ExpressionMigrator)this.getExpressionMigrator());
            }
        }
        if (("proxy".equals(object.getName()) || "ntlm-proxy".equals(object.getName())) && "request-config".equals(object.getParentElement().getName())) {
            Element proxyConfig = new Element("proxy-config", HTTP_NAMESPACE);
            requestConnection = object.getParentElement().getChild("request-connection", HTTP_NAMESPACE);
            object.detach();
            proxyConfig.addContent((Content)object);
            requestConnection.addContent((Content)proxyConfig);
        }
        if ("raml-api-configuration".equals(object.getName())) {
            report.report("http.restConnect", object, object.getParentElement(), new String[0]);
            object.detach();
        }
    }

    protected void copyExpressionAttributeIfPresent(Element source, Element target, String sourceAttributeName, String targetAttributeName, boolean expression) {
        if (source.getAttribute(sourceAttributeName) != null) {
            String sourceAttributeValue;
            String value = sourceAttributeValue = source.getAttributeValue(sourceAttributeName);
            if (expression && this.getExpressionMigrator().isWrapped(sourceAttributeValue)) {
                value = this.getExpressionMigrator().migrateExpression(sourceAttributeValue, true, target);
            }
            target.setAttribute(targetAttributeName, value);
            source.removeAttribute(sourceAttributeName);
        }
    }
}

