/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.http;

import com.google.common.collect.ImmutableList;
import com.mulesoft.tools.migration.library.mule.steps.core.dw.DataWeaveHelper;
import com.mulesoft.tools.migration.library.mule.steps.core.properties.InboundPropertiesHelper;
import com.mulesoft.tools.migration.library.mule.steps.http.AbstractHttpConnectorMigrationStep;
import com.mulesoft.tools.migration.library.tools.mel.MelCompatibilityResolver;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.project.model.applicationgraph.PropertyTranslator;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.CompatibilityResolver;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class HttpConnectorRequester
extends AbstractHttpConnectorMigrationStep {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='request']";

    public String getDescription() {
        return "Update HTTP requester operation.";
    }

    public HttpConnectorRequester() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Element failureValidator;
        Element requestBuilder;
        HttpConnectorRequester.httpRequesterLib(this.getApplicationModel());
        if (!this.getApplicationModel().noCompatibilityMode()) {
            XmlDslUtils.migrateOperationStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report, (boolean)true, (ExpressionMigrator)this.getExpressionMigrator(), (CompatibilityResolver)new MelCompatibilityResolver());
            HttpConnectorRequester.addAttributesToInboundProperties(object, this.getApplicationModel(), report);
        } else {
            report.report("noCompatibility.notFullyImplemented", object, object, new String[0]);
        }
        Namespace httpNamespace = Namespace.getNamespace((String)"http", (String)"http://www.mulesoft.org/schema/mule/http");
        object.setNamespace(httpNamespace);
        if (object.getAttribute("port") != null) {
            report.report("http.port", object, object, new String[]{object.getAttributeValue("port")});
            object.removeAttribute("port");
        }
        if (object.getAttribute("host") != null) {
            report.report("http.host", object, object, new String[]{object.getAttributeValue("host")});
            object.removeAttribute("host");
        }
        if (object.getAttribute("parseResponse") != null) {
            report.report("http.parseResponse", object, object, new String[]{object.getAttributeValue("parseResponse")});
            object.removeAttribute("parseResponse");
        }
        XmlDslUtils.migrateExpression((Attribute)object.getAttribute("path"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)object.getAttribute("method"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)object.getAttribute("followRedirects"), (ExpressionMigrator)this.getExpressionMigrator());
        object.getChildren().forEach(c -> {
            if ("http://www.mulesoft.org/schema/mule/http".equals(c.getNamespaceURI())) {
                this.executeChild((Element)c, report, httpNamespace);
            }
        });
        if (object.getChild("request-builder", httpNamespace) == null) {
            object.addContent((Content)new Element("request-builder", httpNamespace).addContent((Content)HttpConnectorRequester.addHeadersElement(httpNamespace, "#[migration::HttpRequester::httpRequesterHeaders(vars)]")));
        }
        if (object.getAttribute("source") != null) {
            if (!"#[payload]".equals(object.getAttributeValue("source"))) {
                object.addContent((Content)XmlDslUtils.setText((Element)new Element("body", httpNamespace), (String)this.getExpressionMigrator().wrap(this.getExpressionMigrator().migrateExpression(object.getAttributeValue("source"), true, object))));
            }
            object.removeAttribute("source");
        }
        if ((requestBuilder = object.getChild("request-builder", httpNamespace)) != null) {
            object.removeContent((Content)requestBuilder);
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            listBuilder.addAll((Iterable)requestBuilder.getContent().stream().filter(c -> c instanceof Element && ("header".equals(((Element)c).getName()) || "headers".equals(((Element)c).getName()))).collect(Collectors.toList()));
            listBuilder.addAll((Iterable)requestBuilder.getContent().stream().filter(c -> c instanceof Element && ("uri-param".equals(((Element)c).getName()) || "uri-params".equals(((Element)c).getName()))).collect(Collectors.toList()));
            listBuilder.addAll((Iterable)requestBuilder.getContent().stream().filter(c -> c instanceof Element && ("query-param".equals(((Element)c).getName()) || "query-params".equals(((Element)c).getName()))).collect(Collectors.toList()));
            ImmutableList builderContent = listBuilder.build();
            requestBuilder.setContent(Collections.emptyList());
            object.addContent((Collection)builderContent);
        }
        Element responseValidator = null;
        Element successValidator = object.getChild("success-status-code-validator", httpNamespace);
        if (successValidator != null) {
            object.removeContent((Content)successValidator);
            responseValidator = new Element("response-validator", httpNamespace);
            object.addContent((Content)responseValidator);
            responseValidator.addContent((Content)successValidator);
        }
        if ((failureValidator = object.getChild("failure-status-code-validator", httpNamespace)) != null) {
            object.removeContent((Content)failureValidator);
            if (responseValidator == null) {
                responseValidator = new Element("response-validator", httpNamespace);
                object.addContent((Content)responseValidator);
            }
            responseValidator.addContent((Content)failureValidator);
        }
    }

    public static void addAttributesToInboundProperties(Element object, ApplicationModel appModel, MigrationReport report) {
        try {
            InboundPropertiesHelper.addAttributesMapping(appModel, "org.mule.extension.http.api.HttpResponseAttributes", HttpConnectorRequester.inboundToAttributesExpressions(), "message.attributes.headers mapObject ((value, key, index) -> { (if(upper(key as String) startsWith 'X-MULE_') upper((key as String) [2 to -1]) else key) : value })");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> inboundToAttributesExpressions() {
        LinkedHashMap<String, String> expressionsPerProperty = new LinkedHashMap<String, String>();
        expressionsPerProperty.put("http.status", "message.attributes.statusCode");
        expressionsPerProperty.put("http.reason", "message.attributes.reasonPhrase");
        expressionsPerProperty.put("http.headers", "message.attributes.headers");
        return expressionsPerProperty;
    }

    public void executeChild(Element object, MigrationReport report, Namespace httpNamespace) throws RuntimeException {
        object.getChildren().forEach(c -> {
            if ("http://www.mulesoft.org/schema/mule/http".equals(c.getNamespaceURI())) {
                this.executeChild((Element)c, report, httpNamespace);
            }
        });
        if ("request-builder".equals(object.getName())) {
            this.handleReferencedRequestBuilder(object, httpNamespace);
            object.addContent((Content)HttpConnectorRequester.addHeadersElement(httpNamespace, "#[migration::HttpRequester::httpRequesterHeaders(vars)]"));
        }
    }

    public static Element addHeadersElement(Namespace httpNamespace, String headersExpression) {
        return XmlDslUtils.setText((Element)new Element("headers", httpNamespace), (String)headersExpression);
    }

    public static void httpRequesterLib(ApplicationModel appModel) {
        try {
            String headersMap = appModel.noCompatibilityMode() ? "vars filterObject ($$ startsWith 'outbound_') mapObject {($$ dw::core::Strings::substringAfter '_'): $}" : "vars.compatibility_outboundProperties";
            String varMethod = appModel.noCompatibilityMode() ? PropertyTranslator.outboundVariableExpression((String)"http.method") : "vars.compatibility_outboundProperties['http.method']";
            DataWeaveHelper.library(DataWeaveHelper.getMigrationScriptFolder(appModel.getProjectBasePath()), "HttpRequester.dwl", "/**" + System.lineSeparator() + " * Emulates the request headers building logic of the Mule 3.x HTTP Connector." + System.lineSeparator() + " */" + System.lineSeparator() + "fun httpRequesterHeaders(vars: {}) = do {" + System.lineSeparator() + "    var matcher_regex = /(?i)http\\..*|Connection|Host|Transfer-Encoding/" + System.lineSeparator() + "    ---" + System.lineSeparator() + "    " + headersMap + " filterObject" + System.lineSeparator() + "        ((value,key) -> not ((key as String) matches matcher_regex))" + System.lineSeparator() + "        mapObject ((value, key, index) -> {" + System.lineSeparator() + "            (if (upper(key as String) startsWith 'MULE_') upper('X-' ++ key as String) else key) : value" + System.lineSeparator() + "        })" + System.lineSeparator() + "}" + System.lineSeparator() + System.lineSeparator() + "/**" + System.lineSeparator() + " * Emulates the request headers building logic of the Mule 3.x HTTP Transport." + System.lineSeparator() + " */" + System.lineSeparator() + "fun httpRequesterTransportHeaders(vars: {}) = do {" + System.lineSeparator() + "    var matcher_regex = /(?i)http\\..*|Connection|Host|Transfer-Encoding|Accept-Ranges|Age|Content-Disposition|Set-Cookie|ETag|Location|Proxy-Authenticate|Retry-After|Server|Vary|WWW-Authenticate/" + System.lineSeparator() + "    ---" + System.lineSeparator() + "    " + headersMap + " filterObject" + System.lineSeparator() + "        ((value,key) -> not ((key as String) matches matcher_regex))" + System.lineSeparator() + "        mapObject ((value, key, index) -> {" + System.lineSeparator() + "            (if (upper(key as String) startsWith 'MULE_') upper('X-' ++ key as String) else key) : value" + System.lineSeparator() + "        })" + System.lineSeparator() + "}" + System.lineSeparator() + System.lineSeparator() + "/**" + System.lineSeparator() + " * Emulates the request method logic of the Mule 3.x HTTP Connector." + System.lineSeparator() + " */" + System.lineSeparator() + "fun httpRequesterMethod(vars: {}) = do {" + System.lineSeparator() + "    " + varMethod + " default 'POST'" + System.lineSeparator() + "}" + System.lineSeparator() + System.lineSeparator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleReferencedRequestBuilder(Element object, Namespace httpNamespace) {
        Element builderRef = object.getChild("builder", httpNamespace);
        int idx = 0;
        while (builderRef != null) {
            object.removeContent((Content)builderRef);
            Element builder = this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='request-builder' and @name='" + builderRef.getAttributeValue("ref") + "']");
            this.handleReferencedRequestBuilder(builder, httpNamespace);
            ImmutableList builderContent = ImmutableList.copyOf((Collection)builder.getChildren()).asList();
            builder.setContent(Collections.emptyList());
            object.addContent(idx, (Collection)builderContent);
            idx += builderContent.size();
            builderRef = object.getChild("builder", httpNamespace);
        }
    }
}

