/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.http;

import com.mulesoft.tools.migration.library.mule.steps.http.HttpConnectorRequester;
import com.mulesoft.tools.migration.library.mule.steps.validation.ValidationMigration;
import com.mulesoft.tools.migration.library.mule.steps.validation.ValidationPomContribution;
import com.mulesoft.tools.migration.project.ProjectType;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.Arrays;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class HttpPollingConnector
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = "/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='polling-connector']";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update HTTP polling connector.";
    }

    public HttpPollingConnector() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Namespace httpNamespace = Namespace.getNamespace((String)"http", (String)"http://www.mulesoft.org/schema/mule/http");
        TransportsUtils.handleServiceOverrides((Element)object, (MigrationReport)report);
        Element requestConnection = new Element("request-connection", httpNamespace);
        String configName = object.getAttributeValue("name") + "Config";
        object.getParentElement().addContent(1, (Content)new Element("request-config", httpNamespace).setAttribute("name", configName).addContent((Content)requestConnection));
        if (object.getAttribute("reuseAddress") != null) {
            report.report("http.reuseAddress", object, object.getParentElement(), new String[0]);
            object.removeAttribute("reuseAddress");
        }
        if (ProjectType.MULE_FOUR_POLICY.equals((Object)this.getApplicationModel().getProjectType())) {
            report.report("transports.domainConnector", requestConnection, object, new String[0]);
        }
        List pollingEndpoints = this.getApplicationModel().getNodes("//*[@connector-ref = '" + object.getAttributeValue("name") + "']");
        for (Element pollingEndpoint : pollingEndpoints) {
            Element requestOperation = new Element("request", httpNamespace);
            requestOperation.setAttribute("path", "/");
            TransportsUtils.processAddress((Element)pollingEndpoint, (MigrationReport)report).ifPresent(address -> {
                requestConnection.setAttribute("host", address.getHost());
                requestConnection.setAttribute("port", address.getPort());
                if (address.getPath() != null) {
                    requestOperation.setAttribute("path", address.getPath());
                }
                if (address.getCredentials() != null) {
                    String[] credsSplit = address.getCredentials().split("@");
                    Element basicAuth = this.getBasicAuth(requestConnection, httpNamespace);
                    basicAuth.setAttribute("username", credsSplit[0]);
                    basicAuth.setAttribute("password", credsSplit[1]);
                }
            });
            XmlDslUtils.copyAttributeIfPresent((Element)pollingEndpoint, (Element)requestConnection, (String)"host");
            XmlDslUtils.copyAttributeIfPresent((Element)pollingEndpoint, (Element)requestConnection, (String)"port");
            XmlDslUtils.copyAttributeIfPresent((Element)pollingEndpoint, (Element)requestOperation, (String)"path");
            if (pollingEndpoint.getAttribute("user") != null || pollingEndpoint.getAttribute("password") != null) {
                Element basicAuth = this.getBasicAuth(requestConnection, httpNamespace);
                XmlDslUtils.copyAttributeIfPresent((Element)pollingEndpoint, (Element)basicAuth, (String)"user", (String)"username");
                XmlDslUtils.copyAttributeIfPresent((Element)pollingEndpoint, (Element)basicAuth, (String)"password");
            }
            requestOperation.setAttribute("config-ref", configName);
            Element pollingSource = new Element("scheduler", XmlDslUtils.CORE_NAMESPACE).addContent((Content)new Element("scheduling-strategy", XmlDslUtils.CORE_NAMESPACE).addContent((Content)new Element("fixed-frequency", XmlDslUtils.CORE_NAMESPACE).setAttribute("frequency", XmlDslUtils.changeDefault((String)"1000", (String)"60000", (String)object.getAttributeValue("pollingFrequency")))));
            if (object.getAttribute("checkEtag") == null || "true".equals(object.getAttributeValue("checkEtag"))) {
                Element etagValidator = new Element("choice", XmlDslUtils.CORE_NAMESPACE).addContent((Content)new Element("when", XmlDslUtils.CORE_NAMESPACE).setAttribute("expression", "#[message.attributes.headers.ETag != null]").addContent((Content)new Element("idempotent-message-validator", XmlDslUtils.CORE_NAMESPACE).setAttribute("idExpression", "#[message.attributes.headers.ETag]")));
                XmlDslUtils.addElementAfter((Element)etagValidator, (Element)pollingEndpoint);
                report.report("http.eTag", etagValidator, etagValidator, new String[0]);
            }
            if (object.getAttribute("discardEmptyContent") == null || "true".equals(object.getAttributeValue("discardEmptyContent"))) {
                ValidationPomContribution.addValidationDependency((PomModel)this.getApplicationModel().getPomModel().get());
                ValidationMigration.addValidationNamespace(object.getDocument());
                XmlDslUtils.addElementAfter((Element)new Element("is-true", ValidationMigration.VALIDATION_NAMESPACE).setAttribute("expression", "#[(message.attributes.headers['Content-Length'] as Number default -1) != 0]"), (Element)pollingEndpoint);
            }
            for (Element prop : pollingEndpoint.getChildren("property", XmlDslUtils.CORE_NAMESPACE)) {
                requestOperation.addContent((Content)new Element("header", httpNamespace).setAttribute("headerName", prop.getAttributeValue("key")).setAttribute("value", prop.getAttributeValue("value")));
            }
            if (this.getApplicationModel().noCompatibilityMode()) {
                report.report("noCompatibility.notFullyImplemented", object, object, new String[0]);
            } else {
                TransportsUtils.migrateInboundEndpointStructure((ApplicationModel)this.getApplicationModel(), (Element)pollingEndpoint, (MigrationReport)report, (boolean)false);
                HttpConnectorRequester.addAttributesToInboundProperties(pollingEndpoint, this.getApplicationModel(), report);
            }
            pollingEndpoint.getParentElement().addContent(0, Arrays.asList(pollingSource, requestOperation));
            pollingEndpoint.detach();
        }
        object.detach();
    }

    private Element getBasicAuth(Element requestConnection, Namespace httpNamespace) {
        Element basicAuth;
        Element auth = requestConnection.getChild("authentication", httpNamespace);
        if (auth != null) {
            basicAuth = auth.getChild("basic-authentication", httpNamespace);
            if (basicAuth == null) {
                basicAuth = new Element("basic-authentication", httpNamespace);
                auth.addContent((Content)basicAuth);
            }
        } else {
            basicAuth = new Element("basic-authentication", httpNamespace);
            requestConnection.addContent((Content)new Element("authentication", httpNamespace).addContent((Content)basicAuth));
        }
        return basicAuth;
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

