/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.jms;

import com.mulesoft.tools.migration.library.mule.steps.core.dw.DataWeaveHelper;
import com.mulesoft.tools.migration.library.mule.steps.core.properties.InboundPropertiesHelper;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.project.model.pom.Dependency;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.project.model.pom.PomModelUtils;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class AbstractJmsEndpoint
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    protected static final String JMS_NAMESPACE_PREFIX = "jms";
    public static final String JMS_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/jms";
    public static final Namespace JMS_NAMESPACE = Namespace.getNamespace((String)"jms", (String)"http://www.mulesoft.org/schema/mule/jms");
    private ExpressionMigrator expressionMigrator;

    public static void addAttributesToInboundProperties(Element object, ApplicationModel appModel, MigrationReport report) {
        try {
            InboundPropertiesHelper.addAttributesMapping(appModel, "org.mule.extensions.jms.api.message.JmsAttributes", AbstractJmsEndpoint.inboundToAttributesExpressions(), "message.attributes.properties.userProperties");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> inboundToAttributesExpressions() {
        LinkedHashMap<String, String> expressionsPerProperty = new LinkedHashMap<String, String>();
        expressionsPerProperty.put("JMSCorrelationID", "message.attributes.headers.correlationId");
        expressionsPerProperty.put("MULE_CORRELATION_ID", "message.attributes.headers.correlationId");
        expressionsPerProperty.put("JMSDeliveryMode", "message.attributes.headers.deliveryMode");
        expressionsPerProperty.put("JMSDestination", "message.attributes.headers.destination");
        expressionsPerProperty.put("JMSExpiration", "message.attributes.headers.expiration");
        expressionsPerProperty.put("JMSMessageID", "message.attributes.headers.messageId");
        expressionsPerProperty.put("JMSPriority", "message.attributes.headers.priority");
        expressionsPerProperty.put("JMSRedelivered", "message.attributes.headers.redelivered");
        expressionsPerProperty.put("JMSReplyTo", "message.attributes.headers.replyTo.destination");
        expressionsPerProperty.put("JMSTimestamp", "message.attributes.headers.timestamp");
        expressionsPerProperty.put("JMSType", "message.attributes.headers['type']");
        return expressionsPerProperty;
    }

    public static Element mule3Properties(ApplicationModel appModel) {
        return XmlDslUtils.setText((Element)new Element("properties", JMS_NAMESPACE), (String)"#[migration::JmsTransport::jmsPublishProperties(vars)]");
    }

    public static void jmsTransportLib(ApplicationModel appModel) {
        try {
            String outboundMap = appModel.noCompatibilityMode() ? "vars filterObject ($$ startsWith 'outbound_') mapObject {($$ dw::core::Strings::substringAfter '_'): $}" : "vars.compatibility_outboundProperties";
            String outboundPrefix = appModel.noCompatibilityMode() ? "vars.outbound_" : "vars.compatibility_outboundProperties.";
            String inboundJmsReplyTo = appModel.noCompatibilityMode() ? AbstractJmsEndpoint.inboundToAttributesExpressions().get("JMSReplyTo") : "vars.compatibility_inboundProperties.JMSReplyTo";
            DataWeaveHelper.library(DataWeaveHelper.getMigrationScriptFolder(appModel.getProjectBasePath()), "JmsTransport.dwl", "/**" + System.lineSeparator() + " * Emulates the properties building logic of the Mule 3.x JMS Connector." + System.lineSeparator() + " * Replicates logic from org.mule.transport.jms.transformers.AbstractJmsTransformer.setJmsProperties(MuleMessage, Message)." + System.lineSeparator() + " */" + System.lineSeparator() + "fun jmsPublishProperties(vars: {}) = do {" + System.lineSeparator() + "    var jmsProperties = ['JMSCorrelationID', 'JMSDeliveryMode', 'JMSDestination', 'JMSExpiration', 'JMSMessageID', 'JMSPriority', 'JMSRedelivered', 'JMSReplyTo', 'JMSTimestamp', 'JMSType', 'selector', 'MULE_REPLYTO']" + System.lineSeparator() + "    ---" + System.lineSeparator() + "    " + outboundMap + " default {} filterObject" + System.lineSeparator() + "    ((value,key) -> not contains(jmsProperties, (key as String)))" + System.lineSeparator() + "    mapObject ((value, key, index) -> {" + System.lineSeparator() + "        ((key as String) replace \" \" with \"_\") : value" + System.lineSeparator() + "        })" + System.lineSeparator() + "}" + System.lineSeparator() + "" + System.lineSeparator() + "/**" + System.lineSeparator() + " * Adapts the Mule 4 correlationId to the way it was used in 3.x" + System.lineSeparator() + " */" + System.lineSeparator() + "fun jmsCorrelationId(correlationId, vars: {}) = do {" + System.lineSeparator() + "    " + outboundPrefix + "MULE_CORRELATION_ID default correlationId" + System.lineSeparator() + "}" + System.lineSeparator() + "" + System.lineSeparator() + "/**" + System.lineSeparator() + " * Adapts the Mule 4 correlationId to the way it was used in 3.x" + System.lineSeparator() + " */" + System.lineSeparator() + "fun jmsSendCorrelationId(vars: {}) = do {" + System.lineSeparator() + "    if (" + outboundPrefix + "MULE_CORRELATION_ID == null) 'NEVER' else 'ALWAYS'" + System.lineSeparator() + "}" + System.lineSeparator() + "" + System.lineSeparator() + "/**" + System.lineSeparator() + " * Adapts the Mule 4 reply-to to the way it was used in 3.x" + System.lineSeparator() + " */" + System.lineSeparator() + "fun jmsPublishReplyTo(vars: {}) = do {" + System.lineSeparator() + "    " + inboundJmsReplyTo + " default" + System.lineSeparator() + "    (if (" + outboundPrefix + "MULE_REPLYTO != null)" + System.lineSeparator() + "        (" + outboundPrefix + "MULE_REPLYTO splitBy 'jms://')[1]" + System.lineSeparator() + "        else null)" + System.lineSeparator() + "}" + System.lineSeparator() + "" + System.lineSeparator() + "" + System.lineSeparator() + "" + System.lineSeparator() + System.lineSeparator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Optional<Element> resolveJmsConnector(Element object, ApplicationModel appModel) {
        Optional<Element> connector;
        if (object.getAttribute("connector-ref") != null) {
            connector = Optional.of(AbstractJmsEndpoint.getConnector(object.getAttributeValue("connector-ref"), appModel));
            object.removeAttribute("connector-ref");
        } else {
            connector = AbstractJmsEndpoint.getDefaultConnector(appModel);
        }
        return connector;
    }

    protected static Element getConnector(String connectorName, ApplicationModel appModel) {
        return appModel.getNode(StringUtils.substring((String)"/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/jms' and ((local-name() = 'activemq-connector' or local-name() = 'activemq-xa-connector' or local-name() = 'weblogic-connector' or local-name() = 'websphere-connector' or local-name() = 'connector' or local-name() = 'custom-connector'))]", (int)0, (int)-1) + " and @name = '" + connectorName + "']");
    }

    protected static Optional<Element> getDefaultConnector(ApplicationModel appModel) {
        return appModel.getNodeOptional("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/jms' and ((local-name() = 'activemq-connector' or local-name() = 'activemq-xa-connector' or local-name() = 'weblogic-connector' or local-name() = 'websphere-connector' or local-name() = 'connector' or local-name() = 'custom-connector'))]");
    }

    public static String migrateJmsConfig(Element object, MigrationReport report, Optional<Element> connector, ApplicationModel appModel) {
        String configName = connector.map(conn -> conn.getAttributeValue("name")).orElse((object.getAttribute("name") != null ? object.getAttributeValue("name") : (object.getAttribute("ref") != null ? object.getAttributeValue("ref") : "")).replaceAll("\\\\", "_") + "JmsConfig");
        Optional config = appModel.getNodeOptional("*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/jms' and local-name()='config' and @name='" + configName + "']");
        config.orElseGet(() -> {
            Element jmsCfg = new Element("config", JMS_NAMESPACE);
            jmsCfg.setAttribute("name", configName);
            connector.ifPresent(conn -> {
                TransportsUtils.handleServiceOverrides((Element)conn, (MigrationReport)report);
                AbstractJmsEndpoint.addConnectionToConfig(jmsCfg, conn, appModel, report);
            });
            XmlDslUtils.addTopLevelElement((Element)jmsCfg, (Document)connector.map(c -> c.getDocument()).orElse(object.getDocument()));
            return jmsCfg;
        });
        return configName;
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }

    public static void addConnectionToConfig(Element m4JmsConfig, Element m3Connector, ApplicationModel appModel, MigrationReport report) {
        Element connection;
        switch (m3Connector.getName()) {
            case "activemq-connector": {
                connection = AbstractJmsEndpoint.addActiveMqConnection(m4JmsConfig, m3Connector, appModel);
                break;
            }
            case "activemq-xa-connector": {
                connection = AbstractJmsEndpoint.addActiveMqConnection(m4JmsConfig, m3Connector, appModel);
                Element factoryConfig = connection.getChild("factory-configuration", JMS_NAMESPACE);
                if (factoryConfig == null) {
                    factoryConfig = new Element("factory-configuration", JMS_NAMESPACE);
                    connection.addContent((Content)factoryConfig);
                }
                factoryConfig.setAttribute("enable-xa", "true");
                break;
            }
            case "connector": 
            case "custom-connector": {
                report.report("jms.customConnector", m3Connector, m4JmsConfig, new String[0]);
                connection = new Element("generic-connection", JMS_NAMESPACE);
                m4JmsConfig.addContent((Content)connection);
                break;
            }
            case "weblogic-connector": {
                report.report("jms.weblogicMqConnector", m3Connector, m4JmsConfig, new String[0]);
                connection = new Element("generic-connection", JMS_NAMESPACE);
                m4JmsConfig.addContent((Content)connection);
                break;
            }
            case "websphere-connector": {
                report.report("jms.,websphereMqConnector", m3Connector, m4JmsConfig, new String[0]);
                connection = new Element("generic-connection", JMS_NAMESPACE);
                m4JmsConfig.addContent((Content)connection);
                break;
            }
            default: {
                connection = new Element("generic-connection", JMS_NAMESPACE);
                m4JmsConfig.addContent((Content)connection);
            }
        }
        String m4Specification = XmlDslUtils.changeDefault((String)"1.0.2b", (String)"1.1", (String)m3Connector.getAttributeValue("specification"));
        if (m4Specification != null && m4Specification.equals("1.0.2b")) {
            connection.setAttribute("specification", "JMS_1_0_2b");
        }
        XmlDslUtils.copyAttributeIfPresent((Element)m3Connector, (Element)connection, (String)"username");
        XmlDslUtils.copyAttributeIfPresent((Element)m3Connector, (Element)connection, (String)"password");
        XmlDslUtils.copyAttributeIfPresent((Element)m3Connector, (Element)connection, (String)"clientId");
        if (m3Connector.getAttribute("connectionFactory-ref") != null) {
            Element defaultCaching = new Element("default-caching", JMS_NAMESPACE);
            Optional conFactoryOptional = appModel.getNodeOptional("/*/*[@name='" + m3Connector.getAttributeValue("connectionFactory-ref") + "']");
            if (conFactoryOptional.isPresent()) {
                Element connFactory = (Element)conFactoryOptional.get();
                XmlDslUtils.copyAttributeIfPresent((Element)connFactory, (Element)defaultCaching, (String)"sessionCacheSize");
                XmlDslUtils.copyAttributeIfPresent((Element)connFactory, (Element)defaultCaching, (String)"cacheConsumers");
                XmlDslUtils.copyAttributeIfPresent((Element)connFactory, (Element)defaultCaching, (String)"cacheProducers");
                connection.addContent(0, (Content)new Element("caching-strategy", JMS_NAMESPACE).addContent((Content)defaultCaching));
                connFactory.detach();
            } else {
                report.report("jms.beanConnectionFactory", m3Connector, m4JmsConfig, new String[0]);
            }
        } else {
            connection.addContent(0, (Content)new Element("caching-strategy", JMS_NAMESPACE).addContent((Content)new Element("no-caching", JMS_NAMESPACE)));
        }
        if (m3Connector.getAttribute("connectionFactoryJndiName") != null) {
            Element m3customJndiNameResolver;
            Element jndiConnFactory = new Element("jndi-connection-factory", JMS_NAMESPACE);
            XmlDslUtils.copyAttributeIfPresent((Element)m3Connector, (Element)jndiConnFactory, (String)"connectionFactoryJndiName");
            Element nameResolverBuilder = new Element("name-resolver-builder", JMS_NAMESPACE);
            XmlDslUtils.copyAttributeIfPresent((Element)m3Connector, (Element)nameResolverBuilder, (String)"jndiInitialFactory", (String)"jndiInitialContextFactory");
            XmlDslUtils.copyAttributeIfPresent((Element)m3Connector, (Element)nameResolverBuilder, (String)"jndiProviderUrl");
            XmlDslUtils.copyAttributeIfPresent((Element)m3Connector, (Element)nameResolverBuilder, (String)"jndiProviderUrl");
            AbstractJmsEndpoint.processProviderProperties(m3Connector, appModel, nameResolverBuilder);
            Element m3defaultJndiNameResolver = m3Connector.getChild("default-jndi-name-resolver", JMS_NAMESPACE);
            if (m3defaultJndiNameResolver != null) {
                XmlDslUtils.copyAttributeIfPresent((Element)m3defaultJndiNameResolver, (Element)nameResolverBuilder, (String)"jndiInitialFactory", (String)"jndiInitialContextFactory");
                XmlDslUtils.copyAttributeIfPresent((Element)m3defaultJndiNameResolver, (Element)nameResolverBuilder, (String)"jndiProviderUrl");
                AbstractJmsEndpoint.processProviderProperties(m3defaultJndiNameResolver, appModel, nameResolverBuilder);
            }
            if ((m3customJndiNameResolver = m3Connector.getChild("custom-jndi-name-resolver", JMS_NAMESPACE)) != null) {
                XmlDslUtils.copyAttributeIfPresent((Element)m3customJndiNameResolver.getChildren().stream().filter(p -> "jndiInitialFactory".equals(p.getAttributeValue("key"))).findFirst().get(), (Element)nameResolverBuilder, (String)"value", (String)"jndiInitialContextFactory");
                XmlDslUtils.copyAttributeIfPresent((Element)m3customJndiNameResolver.getChildren().stream().filter(p -> "jndiProviderUrl".equals(p.getAttributeValue("key"))).findFirst().get(), (Element)nameResolverBuilder, (String)"value", (String)"jndiProviderUrl");
                m3customJndiNameResolver.getChildren("property", XmlDslUtils.CORE_NAMESPACE).forEach(prop -> {
                    if ("jndiProviderProperties".equals(prop.getAttributeValue("key"))) {
                        AbstractJmsEndpoint.processProviderPropertiesRef(prop.getAttributeValue("value-ref"), appModel, nameResolverBuilder);
                    }
                });
            }
            if ("true".equals(m3Connector.getAttributeValue("jndiDestinations"))) {
                if ("true".equals(m3Connector.getAttributeValue("forceJndiDestinations"))) {
                    jndiConnFactory.setAttribute("lookupDestination", "ALWAYS");
                } else {
                    jndiConnFactory.setAttribute("lookupDestination", "TRY_ALWAYS");
                }
            }
            jndiConnFactory.addContent((Content)nameResolverBuilder);
            Element connFactory = new Element("connection-factory", JMS_NAMESPACE).addContent((Content)jndiConnFactory);
            connection.addContent((Content)connFactory);
        }
    }

    private static void processProviderProperties(Element m3Connector, ApplicationModel appModel, Element nameResolverBuilder) {
        AbstractJmsEndpoint.processProviderPropertiesRef(m3Connector.getAttributeValue("jndiProviderProperties-ref"), appModel, nameResolverBuilder);
    }

    private static void processProviderPropertiesRef(String jndiProviderPropertiesRef, ApplicationModel appModel, Element nameResolverBuilder) {
        if (jndiProviderPropertiesRef != null) {
            Element providerProperties = new Element("provider-properties", JMS_NAMESPACE);
            nameResolverBuilder.addContent((Content)providerProperties);
            appModel.getNodes("//*[@id='" + jndiProviderPropertiesRef + "']/*[namespace-uri()='" + "http://www.springframework.org/schema/beans" + "' and local-name()='prop']").forEach(prop -> providerProperties.addContent((Content)new Element("provider-property", JMS_NAMESPACE).setAttribute("key", prop.getAttributeValue("key")).setAttribute("value", prop.getTextTrim())));
        }
    }

    private static Element addActiveMqConnection(Element m4JmsConfig, Element m3Connector, ApplicationModel appModel) {
        Dependency activeMqClient = new Dependency.DependencyBuilder().withGroupId("org.apache.activemq").withArtifactId("activemq-client").withVersion("${activeMq.version}").build();
        PomModelUtils.addSharedLibs((PomModel)((PomModel)appModel.getPomModel().get()), (Dependency[])new Dependency[]{activeMqClient});
        Element amqConnection = new Element("active-mq-connection", JMS_NAMESPACE);
        m4JmsConfig.addContent((Content)amqConnection);
        boolean addFactory = false;
        Element factoryConfiguration = new Element("factory-configuration", JMS_NAMESPACE);
        if (m3Connector.getAttribute("brokerURL") != null) {
            factoryConfiguration.setAttribute("brokerUrl", m3Connector.getAttributeValue("brokerURL"));
            addFactory = true;
        }
        if (m3Connector.getAttributeValue("maxRedelivery") != null) {
            factoryConfiguration.setAttribute("maxRedelivery", m3Connector.getAttributeValue("maxRedelivery"));
            addFactory = true;
        }
        if (addFactory) {
            amqConnection.addContent((Content)factoryConfiguration);
        }
        return amqConnection;
    }
}

