/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.jms;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.jms.AbstractJmsEndpoint;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Optional;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class JmsInboundEndpoint
extends AbstractJmsEndpoint {
    public static final String XPATH_SELECTOR = "/*/mule:flow/*[namespace-uri()='http://www.mulesoft.org/schema/mule/jms' and local-name()='inbound-endpoint']";

    public String getDescription() {
        return "Update JMS transport inbound endpoint.";
    }

    public JmsInboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{JMS_NAMESPACE}));
    }

    private String mapTransactionalAction(String action, MigrationReport report, Element tx, Element object) {
        if ("NONE".equals(action)) {
            return "NONE";
        }
        if ("ALWAYS_BEGIN".equals(action)) {
            return "ALWAYS_BEGIN";
        }
        if ("BEGIN_OR_JOIN".equals(action)) {
            report.report("jms.listenerTx", tx, object, new String[0]);
            return "ALWAYS_BEGIN";
        }
        if ("ALWAYS_JOIN".equals(action)) {
            report.report("jms.listenerTx", tx, object, new String[0]);
            return "NONE";
        }
        if ("JOIN_IF_POSSIBLE".equals(action)) {
            report.report("jms.listenerTx", tx, object, new String[0]);
            return "NONE";
        }
        if ("NOT_SUPPORTED".equals(action)) {
            return "NONE";
        }
        return action;
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        String txAction;
        JmsInboundEndpoint.jmsTransportLib(this.getApplicationModel());
        XmlDslUtils.addMigrationAttributeToElement((Element)object, (Attribute)new Attribute("isMessageSource", "true"));
        Element tx = object.getChild("transaction", JMS_NAMESPACE);
        while (tx != null) {
            String txAction2 = this.mapTransactionalAction(tx.getAttributeValue("action"), report, tx, object);
            object.setAttribute("transactionalAction", txAction2);
            object.removeChild("transaction", JMS_NAMESPACE);
            tx = object.getChild("transaction", JMS_NAMESPACE);
        }
        while (object.getChild("xa-transaction", XmlDslUtils.CORE_NAMESPACE) != null) {
            Element xaTx = object.getChild("xa-transaction", XmlDslUtils.CORE_NAMESPACE);
            txAction = this.mapTransactionalAction(xaTx.getAttributeValue("action"), report, xaTx, object);
            object.setAttribute("transactionalAction", txAction);
            object.setAttribute("transactionType", "XA");
            object.removeChild("xa-transaction", XmlDslUtils.CORE_NAMESPACE);
        }
        while (object.getChild("multi-transaction", XmlDslUtils.CORE_EE_NAMESPACE) != null) {
            Element multiTx = object.getChild("multi-transaction", XmlDslUtils.CORE_EE_NAMESPACE);
            txAction = this.mapTransactionalAction(multiTx.getAttributeValue("action"), report, multiTx, object);
            object.setAttribute("transactionalAction", txAction);
            object.removeChild("multi-transaction", XmlDslUtils.CORE_EE_NAMESPACE);
        }
        this.getApplicationModel();
        ApplicationModel.addNameSpace((Namespace)JMS_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/jms/current/mule-jms.xsd", (Document)object.getDocument());
        object.setNamespace(JMS_NAMESPACE);
        object.setName("listener");
        Optional<Element> connector = JmsInboundEndpoint.resolveJmsConnector(object, this.getApplicationModel());
        String configName = JmsInboundEndpoint.migrateJmsConfig(object, report, connector, this.getApplicationModel());
        connector.ifPresent(m3c -> {
            XmlDslUtils.migrateReconnect((Element)m3c, (Element)object, (MigrationReport)report, (Element)object);
            if (m3c.getAttributeValue("acknowledgementMode") != null) {
                switch (m3c.getAttributeValue("acknowledgementMode")) {
                    case "CLIENT_ACKNOWLEDGE": {
                        object.setAttribute("ackMode", "MANUAL");
                        break;
                    }
                    case "DUPS_OK_ACKNOWLEDGE": {
                        object.setAttribute("ackMode", "DUPS_OK");
                        break;
                    }
                }
            }
            if (m3c.getAttributeValue("numberOfConsumers") != null) {
                object.setAttribute("numberOfConsumers", m3c.getAttributeValue("numberOfConsumers"));
            }
            TransportsUtils.handleConnectorChildElements((Element)m3c, (Element)this.getApplicationModel().getNode("*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/jms' and local-name()='config' and @name='" + configName + "']"), (Element)new Element("connection", XmlDslUtils.CORE_NAMESPACE), (MigrationReport)report);
        });
        String destination = TransportsUtils.processAddress((Element)object, (MigrationReport)report).map(address -> {
            String path = address.getPath();
            if ("topic".equals(path)) {
                this.configureTopicListener(object, JMS_NAMESPACE, connector);
                return address.getPort();
            }
            return path;
        }).orElseGet(() -> {
            if (object.getAttributeValue("queue") != null) {
                return object.getAttributeValue("queue");
            }
            this.configureTopicListener(object, JMS_NAMESPACE, connector);
            return object.getAttributeValue("topic");
        });
        if (object.getAttribute("exchange-pattern") == null || object.getAttributeValue("exchange-pattern").equals("request-response")) {
            Element outboundBuilder = new Element("response", JMS_NAMESPACE);
            outboundBuilder.addContent((Content)JmsInboundEndpoint.mule3Properties(this.getApplicationModel()));
            outboundBuilder.setAttribute("correlationId", "#[migration::JmsTransport::jmsCorrelationId(correlationId, vars)]");
            report.report("jms.propertiesListener", object, object, new String[0]);
            connector.ifPresent(m3c -> {
                if (m3c.getAttributeValue("persistentDelivery") != null) {
                    outboundBuilder.setAttribute("persistentDelivery", m3c.getAttributeValue("persistentDelivery"));
                }
            });
            object.addContent((Content)outboundBuilder);
        }
        if (object.getChild("selector", JMS_NAMESPACE) != null) {
            object.setAttribute("selector", object.getChild("selector", JMS_NAMESPACE).getAttributeValue("expression"));
            object.removeChild("selector", JMS_NAMESPACE);
        }
        object.setAttribute("config-ref", configName);
        if (destination != null) {
            object.setAttribute("destination", destination);
        }
        object.removeAttribute("queue");
        object.removeAttribute("topic");
        object.removeAttribute("name");
        object.removeAttribute("responseTimeout");
        object.removeAttribute("xaPollingTimeout");
        if (object.getAttribute("exchange-pattern") == null || object.getAttributeValue("exchange-pattern").equals("request-response")) {
            TransportsUtils.migrateInboundEndpointStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report, (boolean)true);
        } else {
            TransportsUtils.migrateInboundEndpointStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report, (boolean)false);
        }
        JmsInboundEndpoint.addAttributesToInboundProperties(object, this.getApplicationModel(), report);
    }

    private void configureTopicListener(Element object, Namespace jmsConnectorNamespace, Optional<Element> connector) {
        Element topicConsumer = new Element("topic-consumer", jmsConnectorNamespace);
        connector.ifPresent(m3c -> {
            XmlDslUtils.copyAttributeIfPresent((Element)m3c, (Element)topicConsumer, (String)"durable");
            m3c.removeAttribute("durable");
            m3c.removeAttribute("subscriptionName");
        });
        object.setAttribute("numberOfConsumers", "1");
        object.addContent((Content)new Element("consumer-type", jmsConnectorNamespace).addContent((Content)topicConsumer));
    }
}

