/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.os;

import com.mulesoft.tools.migration.library.tools.PluginsVersions;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.project.model.pom.Dependency;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class AbstractOSMigrator
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    protected static final String OS_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/objectstore";
    protected static final String OS_SCHEMA = "http://www.mulesoft.org/schema/mule/objectstore/current/mule-objectstore.xsd";
    protected static final String OS_NAMESPACE_PREFIX = "objectstore";
    protected static final Namespace OS_NAMESPACE = Namespace.getNamespace((String)"objectstore", (String)"http://www.mulesoft.org/schema/mule/objectstore");
    protected static final String NEW_OS_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/os";
    protected static final String NEW_OS_SCHEMA = "http://www.mulesoft.org/schema/mule/os/current/mule-os.xsd";
    protected static final String NEW_OS_NAMESPACE_PREFIX = "os";
    protected static final Namespace NEW_OS_NAMESPACE = Namespace.getNamespace((String)"os", (String)"http://www.mulesoft.org/schema/mule/os");
    private ExpressionMigrator expressionMigrator;

    protected void migrateOS(Element element) {
        this.getApplicationModel().removeNameSpace(OS_NAMESPACE, OS_SCHEMA, element.getDocument());
        this.getApplicationModel();
        ApplicationModel.addNameSpace((Namespace)NEW_OS_NAMESPACE, (String)NEW_OS_SCHEMA, (Document)element.getDocument());
        element.setNamespace(NEW_OS_NAMESPACE);
        this.migrateConnection(element);
    }

    protected void migrateConnection(Element element) {
        Attribute config = element.getAttribute("config-ref");
        if (config != null) {
            config.setName("objectStore");
            Element osBean = this.getApplicationModel().getNodeOptional("//*[namespace-uri()='http://www.springframework.org/schema/beans' and local-name()='bean' and @id = '" + config.getValue() + "']").orElse(null);
            if (osBean != null) {
                osBean.detach();
                Element osConfig = new Element("object-store", NEW_OS_NAMESPACE);
                osConfig.setAttribute("name", config.getValue());
                osConfig.setAttribute("persistent", "false");
                XmlDslUtils.addTopLevelElement((Element)osConfig, (Document)element.getDocument());
            }
        }
    }

    protected void addNewRetrieveOperation(Element element, int position) {
        Element retrieveOperation = new Element("retrieve", NEW_OS_NAMESPACE);
        retrieveOperation.setAttribute(new Attribute("key", element.getAttributeValue("key")));
        retrieveOperation.setAttribute(new Attribute("objectStore", element.getAttributeValue("config-ref")));
        Attribute defaultValue = element.getAttribute("defaultValue-ref");
        if (defaultValue != null) {
            this.setOSValue(retrieveOperation, this.getExpressionMigrator().migrateExpression(defaultValue.getValue(), true, element), "default-value");
        }
        element.getParentElement().addContent(position, (Content)retrieveOperation);
    }

    protected void addNewStoreOperation(Element element, int position) {
        Element storeOperation = new Element("store", NEW_OS_NAMESPACE);
        storeOperation.setAttribute(new Attribute("key", element.getAttributeValue("key")));
        storeOperation.setAttribute(new Attribute("objectStore", element.getAttributeValue("config-ref")));
        Attribute defaultValue = element.getAttribute("defaultValue-ref");
        if (defaultValue != null) {
            this.setOSValue(storeOperation, this.getExpressionMigrator().migrateExpression(defaultValue.getValue(), true, element), "value");
        }
        element.getParentElement().addContent(position, (Content)storeOperation);
    }

    protected void setOSValue(Element os, String value, String childName) {
        Element childValue = new Element(childName, NEW_OS_NAMESPACE);
        XmlDslUtils.setText((Element)childValue, (String)value);
        os.addContent((Content)childValue);
    }

    protected void addOSModule() {
        this.getApplicationModel().getPomModel().ifPresent(pom -> pom.addDependency(new Dependency.DependencyBuilder().withGroupId("org.mule.connectors").withArtifactId("mule-objectstore-connector").withVersion(PluginsVersions.targetVersion("mule-objectstore-connector")).withClassifier("mule-plugin").build()));
        this.getApplicationModel().addNameSpace(NEW_OS_NAMESPACE_PREFIX, NEW_OS_NAMESPACE_URI, NEW_OS_SCHEMA);
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

