/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.pom;

import com.mulesoft.tools.migration.project.model.pom.Plugin;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.project.model.pom.PomModelUtils;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.category.PomContribution;
import java.util.HashSet;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class UpdateMuleMavenPlugin
implements PomContribution {
    private static final String DEPLOYMENT_TYPE_PROPERTY = "deploymentType";
    private static final String DEPLOYMENT_CONFIGURATION_PROPERTY_SUFFIX = "Deployment";

    public String getDescription() {
        return "Update mule-maven-plugin";
    }

    public void execute(PomModel pomModel, MigrationReport report) throws RuntimeException {
        String packagingType = pomModel.getPackaging();
        if (StringUtils.equals((CharSequence)packagingType, (CharSequence)"mule")) {
            pomModel.setPackaging("mule-application");
        }
        Plugin muleMavenPlugin = pomModel.removePlugin(p -> p.getArtifactId().equals("mule-maven-plugin")).orElse(PomModelUtils.buildMule4MuleMavenPluginConfiguration());
        muleMavenPlugin.setVersion("3.2.1");
        muleMavenPlugin.setExtensions("true");
        Xpp3Dom configuration = muleMavenPlugin.getConfiguration();
        if (configuration != null) {
            this.updateDeploymentConfiguration(configuration);
        }
        pomModel.addPlugin(muleMavenPlugin);
    }

    protected void updateDeploymentConfiguration(Xpp3Dom configuration) {
        OptionalInt deploymentTypeIndex = IntStream.range(0, configuration.getChildCount()).filter(k -> DEPLOYMENT_TYPE_PROPERTY.equals(configuration.getChild(k).getName())).findFirst();
        if (deploymentTypeIndex.isPresent()) {
            String deploymentConfigurationPrefix = configuration.getChild(deploymentTypeIndex.getAsInt()).getValue();
            String deploymentConfigurationName = deploymentConfigurationPrefix + DEPLOYMENT_CONFIGURATION_PROPERTY_SUFFIX;
            configuration.removeChild(deploymentTypeIndex.getAsInt());
            this.updateConfigurationWithNewDeploymentConfiguration(deploymentConfigurationName, configuration);
        }
    }

    protected void updateConfigurationWithNewDeploymentConfiguration(String deploymentConfigurationName, Xpp3Dom configuration) {
        Xpp3Dom deploymentConfiguration = new Xpp3Dom(deploymentConfigurationName);
        Set<String> deploymentParameters = this.getDeploymentParameters();
        for (String deploymentParameter : deploymentParameters) {
            this.moveChildWithName(deploymentParameter, configuration, deploymentConfiguration);
        }
        configuration.addChild(deploymentConfiguration);
    }

    protected void moveChildWithName(String childName, Xpp3Dom from, Xpp3Dom to) {
        for (int k = 0; k < from.getChildren().length; ++k) {
            Xpp3Dom currentChild = from.getChild(k);
            if (!currentChild.getName().equals(childName)) continue;
            from.removeChild(k);
            to.addChild(currentChild);
            break;
        }
    }

    protected Set<String> getDeploymentParameters() {
        HashSet<String> deploymentParameters = new HashSet<String>();
        deploymentParameters.add("deploymentTimeout");
        deploymentParameters.add("arguments");
        deploymentParameters.add("region");
        deploymentParameters.add("workers");
        deploymentParameters.add("workerType");
        deploymentParameters.add("domain");
        deploymentParameters.add("script");
        deploymentParameters.add("timeout");
        deploymentParameters.add("username");
        deploymentParameters.add("password");
        deploymentParameters.add("uri");
        deploymentParameters.add("environment");
        deploymentParameters.add("muleHome");
        deploymentParameters.add("size");
        deploymentParameters.add("businessGroup");
        deploymentParameters.add("armInsecure");
        deploymentParameters.add("target");
        deploymentParameters.add("targetType");
        return deploymentParameters;
    }
}

