/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.quartz;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class QuartzOutboundEndpoint
extends AbstractApplicationModelMigrationStep {
    protected static final String QUARTZ_NS_PREFIX = "quartz";
    protected static final String QUARTZ_NS_URI = "http://www.mulesoft.org/schema/mule/quartz";
    private static final Namespace QUARTZ_NS = Namespace.getNamespace((String)"quartz", (String)"http://www.mulesoft.org/schema/mule/quartz");
    public static final String XPATH_SELECTOR = "//*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/quartz' and local-name() = 'outbound-endpoint']";

    public String getDescription() {
        return "Remove quartz outbound endpoints.";
    }

    public QuartzOutboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        report.report("quartz.outboundEndpoint", object, object.getParentElement(), new String[0]);
        Element endpointPollingJob = object.getChild("scheduled-dispatch-job", QUARTZ_NS);
        if (endpointPollingJob != null) {
            Element jobEndpoint = endpointPollingJob.getChild("job-endpoint", QUARTZ_NS);
            jobEndpoint.detach();
            jobEndpoint.setName("outbound-endpoint");
            jobEndpoint.setNamespace(XmlDslUtils.CORE_NAMESPACE);
            XmlDslUtils.addElementAfter((Element)jobEndpoint, (Element)object);
            object.detach();
        }
    }
}

