/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.salesforce;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.salesforce.AbstractSalesforceOperationMigrationStep;
import com.mulesoft.tools.migration.library.tools.SalesforceUtils;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class CreateJobOperation
extends AbstractSalesforceOperationMigrationStep
implements ExpressionMigratorAware {
    private static final String name = "create-job";

    public CreateJobOperation() {
        super(name);
        this.setAppliedTo(XmlDslUtils.getXPathSelector((String)"http://www.mulesoft.org/schema/mule/sfdc", (String)name, (boolean)false));
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{SalesforceUtils.MULE3_SALESFORCE_NAMESPACE}));
    }

    @Override
    public void execute(Element mule3Operation, MigrationReport report) throws RuntimeException {
        super.execute(mule3Operation, report);
        this.resolveAttributes(mule3Operation, this.mule4Operation);
        XmlDslUtils.addElementAfter((Element)this.mule4Operation, (Element)mule3Operation);
        mule3Operation.getParentElement().removeContent((Content)mule3Operation);
    }

    private void resolveAttributes(Element mule3Operation, Element mule4Operation) {
        SalesforceUtils.resolveTypeAttribute(mule3Operation, mule4Operation);
        String operation = mule3Operation.getAttributeValue("operation");
        if (operation != null && !operation.isEmpty()) {
            mule4Operation.setAttribute("operation", operation);
        }
        String externalIdFieldName = mule3Operation.getAttributeValue("externalIdFieldName");
        String concurrencyMode = mule3Operation.getAttributeValue("concurrencyMode");
        String contentType = mule3Operation.getAttributeValue("contentType");
        StringBuilder requestContents = new StringBuilder();
        if (externalIdFieldName != null && !externalIdFieldName.isEmpty()) {
            requestContents.append("externalIdFieldName: \"" + externalIdFieldName + "\"");
        }
        if (concurrencyMode != null && !concurrencyMode.isEmpty()) {
            if (requestContents != null && requestContents.length() != 0) {
                requestContents.append(", \n");
            }
            requestContents.append("concurrencyMode: \"" + concurrencyMode + "\"");
        }
        if (contentType != null && !contentType.isEmpty()) {
            if (requestContents != null && requestContents.length() != 0) {
                requestContents.append(", \n");
            }
            requestContents.append("contentType: \"" + contentType + "\"");
        }
        if (requestContents != null && requestContents.length() != 0) {
            Element createJobRequest = new Element("create-job-request", SalesforceUtils.MULE4_SALESFORCE_NAMESPACE);
            createJobRequest.setContent((Content)new CDATA("%dw 2.0 output application/java\n---\n{\n" + requestContents.toString() + "\n} as Object { class : \"org.mule.extension.salesforce.api.bulk.CreateJobRequest\" }"));
            mule4Operation.addContent((Content)createJobRequest);
        }
    }
}

