/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.security.properties;

import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.version.VersionUtils;
import java.util.Collections;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SecurePropertiesPlaceholder
extends AbstractApplicationModelMigrationStep {
    private static final String SECURE_NS_URI = "http://www.mulesoft.org/schema/mule/secure-properties";
    private static final String SECURE_SCHEMA = "http://www.mulesoft.org/schema/mule/secure-properties/current/mule-secure-properties.xsd";
    public static final Namespace SECURE_NAMESPACE = Namespace.getNamespace((String)"secure-properties", (String)"http://www.mulesoft.org/schema/mule/secure-properties");
    public static final String XPATH_SELECTOR = "/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/secure-property-placeholder' and local-name()='config']";

    public String getDescription() {
        return "Migrates the secure property placeholders.";
    }

    public SecurePropertiesPlaceholder() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Collections.singletonList(Namespace.getNamespace((String)"secure-property-placeholder", (String)"http://www.mulesoft.org/schema/mule/secure-property-placeholder")));
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        this.getApplicationModel();
        ApplicationModel.addNameSpace((Namespace)SECURE_NAMESPACE, (String)SECURE_SCHEMA, (Document)object.getDocument());
        int idx = object.getParent().indexOf((Content)object);
        int j = 1;
        for (String location : object.getAttributeValue("location").split("\\,")) {
            Element confProp = new Element("config", SECURE_NAMESPACE);
            confProp.setAttribute("file", location);
            if (object.getAttribute("fileEncoding") != null) {
                if (VersionUtils.isVersionGreaterOrEquals((String)this.getApplicationModel().getMuleVersion(), (String)"4.2.0").booleanValue()) {
                    confProp.setAttribute("encoding", object.getAttributeValue("fileEncoding"));
                } else {
                    report.report("configProperties.encoding", object, object, new String[0]);
                }
            }
            confProp.setAttribute("key", object.getAttributeValue("key"));
            confProp.setAttribute("name", object.getAttributeValue("name") + (j > 1 ? "_" + j : ""));
            Element encryptProp = new Element("encrypt", SECURE_NAMESPACE);
            encryptProp.setAttribute("algorithm", object.getAttributeValue("encryptionAlgorithm", "AES"));
            encryptProp.setAttribute("mode", object.getAttributeValue("encryptionMode", "CBC"));
            confProp.addContent((Content)encryptProp);
            object.getDocument().getRootElement().addContent(idx, (Content)confProp);
            report.report("configProperties.securePrefix", confProp, confProp, new String[0]);
            ++j;
        }
        if (Boolean.parseBoolean(object.getAttributeValue("ignoreResourceNotFound", "false"))) {
            report.report("configProperties.ignoreResourceNotFound", object, object, new String[0]);
        }
        if (Boolean.parseBoolean(object.getAttributeValue("ignoreUnresolvablePlaceholders", "false"))) {
            report.report("configProperties.ignoreUnresolvablePlaceholders", object, object, new String[0]);
        }
        if (!"FALLBACK".equals(object.getAttributeValue("systemPropertiesMode", "FALLBACK"))) {
            report.report("configProperties.systemPropertiesMode", object, object, new String[0]);
        }
        object.detach();
    }
}

