/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.sftp;

import com.mulesoft.tools.migration.library.mule.steps.sftp.SftpConfig;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract class AbstractSftpEndpoint
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    protected static final String SFTP_NS_PREFIX = "sftp";
    public static final String SFTP_NS_URI = "http://www.mulesoft.org/schema/mule/sftp";
    private ExpressionMigrator expressionMigrator;

    protected Element migrateSftpConfig(Element object, String configName, Optional<Element> config, MigrationReport report) {
        Element sftpConfig = config.orElseGet(() -> {
            Element sftpCfg = new Element("config", SftpConfig.SFTP_NAMESPACE);
            sftpCfg.setAttribute("name", configName != null ? configName : (object.getAttributeValue("name") != null ? object.getAttributeValue("name") : XmlDslUtils.getContainerElement((Element)object).getAttributeValue("name") + "Sftp") + "Config");
            Element conn = new Element("connection", SftpConfig.SFTP_NAMESPACE);
            XmlDslUtils.migrateReconnection((Element)conn, (Element)object, (MigrationReport)report);
            sftpCfg.addContent((Content)conn);
            XmlDslUtils.addTopLevelElement((Element)sftpCfg, (Document)object.getDocument());
            return sftpCfg;
        });
        return sftpConfig;
    }

    protected String resolveDirectory(String endpointPath) {
        if (endpointPath.equals("/~")) {
            return "~";
        }
        if (endpointPath.startsWith("/~/")) {
            return StringUtils.substring((String)endpointPath, (int)3);
        }
        if (endpointPath.startsWith("/")) {
            return StringUtils.substring((String)endpointPath, (int)1);
        }
        return endpointPath;
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

