/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.sftp;

import com.mulesoft.tools.migration.library.mule.steps.core.properties.InboundPropertiesHelper;
import com.mulesoft.tools.migration.library.mule.steps.file.FileConfig;
import com.mulesoft.tools.migration.library.mule.steps.file.FileInboundEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.sftp.AbstractSftpEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.sftp.SftpConfig;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class SftpInboundEndpoint
extends AbstractSftpEndpoint {
    public static final String XPATH_SELECTOR = "/*/mule:flow/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/sftp' and local-name() = 'inbound-endpoint'][1]";

    public String getDescription() {
        return "Update SFTP inbound endpoints.";
    }

    public SftpInboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        object.setName("listener");
        object.setNamespace(SftpConfig.SFTP_NAMESPACE);
        XmlDslUtils.addMigrationAttributeToElement((Element)object, (Attribute)new Attribute("isMessageSource", "true"));
        String configName = object.getAttributeValue("connector-ref");
        Optional config = configName != null ? this.getApplicationModel().getNodeOptional("/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/sftp' and local-name() = 'config' and @name = '" + configName + "']") : this.getApplicationModel().getNodeOptional("/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/sftp' and local-name() = 'config']");
        Element sftpConfig = this.migrateSftpConfig(object, configName, config, report);
        Element connection = sftpConfig.getChild("connection", SftpConfig.SFTP_NAMESPACE);
        this.addAttributesToInboundProperties(object, report);
        Element redelivery = object.getChild("idempotent-redelivery-policy", XmlDslUtils.CORE_NAMESPACE);
        if (redelivery != null) {
            redelivery.setName("redelivery-policy");
            Attribute exprAttr = redelivery.getAttribute("idExpression");
            if (exprAttr != null) {
                exprAttr.setValue(exprAttr.getValue().replaceAll("#\\[header\\:inbound\\:originalFilename\\]", "#[attributes.name]"));
                if (this.getExpressionMigrator().isWrapped(exprAttr.getValue())) {
                    exprAttr.setValue(this.getExpressionMigrator().wrap(this.getExpressionMigrator().migrateExpression(exprAttr.getValue(), true, object)));
                }
            }
            XmlDslUtils.migrateRedeliveryPolicyChildren((Element)redelivery, (MigrationReport)report);
        }
        TransportsUtils.migrateSchedulingStrategy((Element)object, (OptionalInt)OptionalInt.of(1000));
        if (object.getAttribute("sizeCheckWaitTime") != null && !"0".equals(object.getAttributeValue("sizeCheckWaitTime"))) {
            String sizeCheckWaitTime = object.getAttributeValue("sizeCheckWaitTime");
            object.setAttribute("timeBetweenSizeCheck", sizeCheckWaitTime);
            object.removeAttribute("sizeCheckWaitTime");
        } else if (object.getAttribute("fileAge") != null && !"0".equals(object.getAttributeValue("fileAge"))) {
            String fileAge = object.getAttributeValue("fileAge");
            object.setAttribute("timeBetweenSizeCheck", fileAge);
            object.removeAttribute("fileAge");
        }
        if (object.getAttribute("tempDir") != null || object.getAttribute("useTempFileTimestampSuffix") != null) {
            report.report("sftp.tempDir", object, object, new String[0]);
            object.removeAttribute("tempDir");
            object.removeAttribute("useTempFileTimestampSuffix");
        }
        this.doExecute(object, report);
        FileInboundEndpoint.migrateFileFilters(object, report, SftpConfig.SFTP_NAMESPACE, this.getApplicationModel());
        TransportsUtils.processAddress((Element)object, (MigrationReport)report).ifPresent(address -> {
            connection.setAttribute("host", address.getHost());
            connection.setAttribute("port", address.getPort());
            if (address.getCredentials() != null) {
                String[] credsSplit = address.getCredentials().split(":");
                connection.setAttribute("username", credsSplit[0]);
                if (credsSplit.length > 1) {
                    connection.setAttribute("password", credsSplit[1]);
                }
            }
            object.setAttribute("path", address.getPath() != null ? this.resolveDirectory(address.getPath()) : "/");
        });
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"host");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"port");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"user", (String)"username");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"password");
        Attribute pathAttr = object.getAttribute("path");
        if (pathAttr != null) {
            pathAttr.setName("directory");
        }
        if (object.getAttribute("connector-ref") != null) {
            object.getAttribute("connector-ref").setName("config-ref");
        } else {
            object.setAttribute("config-ref", sftpConfig.getAttributeValue("name"));
        }
        object.removeAttribute("name");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"identityFile");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"passphrase");
        if (object.getAttribute("knownHostsFile") != null && connection.getAttribute("knownHostsFile") == null) {
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"knownHostsFile");
        }
        object.removeAttribute("knownHostsFile");
        if (object.getAttribute("archiveDir") != null) {
            String fileArchiveConfigName = sftpConfig.getAttributeValue("name") + "Archive";
            XmlDslUtils.addTopLevelElement((Element)new Element("config", FileConfig.FILE_NAMESPACE).setAttribute("name", fileArchiveConfigName).addContent((Content)new Element("connection", FileConfig.FILE_NAMESPACE).setAttribute("workingDir", object.getAttributeValue("archiveDir"))), (Document)object.getDocument());
            object.getParentElement().addContent(3, (Content)new Element("write", FileConfig.FILE_NAMESPACE).setAttribute("config-ref", fileArchiveConfigName).setAttribute("path", "#[attributes.name]"));
            object.removeAttribute("archiveDir");
            object.removeAttribute("archiveTempReceivingDir");
            object.removeAttribute("archiveTempSendingDir");
        }
        if (object.getAttribute("responseTimeout") != null) {
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"responseTimeout", (String)"connectionTimeout");
            connection.setAttribute("connectionTimeoutUnit", "MILLISECONDS");
        }
        if (object.getAttribute("exchange-pattern") != null) {
            object.removeAttribute("exchange-pattern");
        }
    }

    protected Optional<Element> fetchConfig(String configName) {
        return this.getApplicationModel().getNodeOptional("/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/sftp' and local-name() = 'config']");
    }

    protected void doExecute(Element object, MigrationReport report) {
    }

    private void addAttributesToInboundProperties(Element object, MigrationReport report) {
        TransportsUtils.migrateInboundEndpointStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report, (boolean)true);
        try {
            InboundPropertiesHelper.addAttributesMapping(this.getApplicationModel(), "org.mule.extension.sftp.api.SftpFileAttributes", SftpInboundEndpoint.inboundToAttributesExpressions(), new String[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> inboundToAttributesExpressions() {
        LinkedHashMap<String, String> expressionsPerProperty = new LinkedHashMap<String, String>();
        expressionsPerProperty.put("originalFilename", "message.attributes.name");
        expressionsPerProperty.put("filename", "message.attributes.name");
        return expressionsPerProperty;
    }
}

