/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.splitter;

import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.mule.runtime.api.util.LazyValue;

public class SplitterAggregatorInfo {
    private static final String SPLITTER_GLOBAL_VALUES = "splitterGlobalValues";
    private static final String SPLITTER_GLOBAL_INDEXES = "splitterGlobalIndexes";
    private Element splitterElement;
    private ApplicationModel applicationModel;
    private LazyValue<Integer> documentIdLazyValue;
    private LazyValue<Integer> splitterIndexLazyValue;

    public SplitterAggregatorInfo(Element splitterElement, ApplicationModel applicationModel) {
        this.splitterElement = splitterElement;
        this.applicationModel = applicationModel;
        this.documentIdLazyValue = new LazyValue(() -> Math.abs(Objects.hashCode(Paths.get(applicationModel.getProjectBasePath().toUri().toString(), new String[0]).relativize(Paths.get(splitterElement.getDocument().getBaseURI(), new String[0])).toString())));
        this.splitterIndexLazyValue = new LazyValue(() -> {
            Optional splitterGlobalValuesElementOptional = applicationModel.getNodeOptional("//*[local-name()='splitterGlobalValues' and namespace-uri()='" + XmlDslUtils.MIGRATION_NAMESPACE.getURI() + "']");
            Element splitterGlobalValuesElement = splitterGlobalValuesElementOptional.orElseGet(() -> {
                Element globalValues = new Element(SPLITTER_GLOBAL_VALUES, XmlDslUtils.MIGRATION_NAMESPACE);
                Element globalIndexes = new Element(SPLITTER_GLOBAL_INDEXES, XmlDslUtils.MIGRATION_NAMESPACE);
                globalValues.addContent((Content)globalIndexes);
                XmlDslUtils.addTopLevelElement((Element)globalValues, (Document)splitterElement.getDocument());
                return globalValues;
            });
            int newId = 0;
            try {
                Element globalIndexesElement = splitterGlobalValuesElement.getChild(SPLITTER_GLOBAL_INDEXES, XmlDslUtils.MIGRATION_NAMESPACE);
                Attribute newIdAttribute = globalIndexesElement.getAttribute(splitterElement.getName());
                if (newIdAttribute == null) {
                    newIdAttribute = new Attribute(splitterElement.getName(), "-1");
                    globalIndexesElement.setAttribute(newIdAttribute);
                }
                newId = newIdAttribute.getIntValue() + 1;
                newIdAttribute.setValue(Integer.toString(newId));
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
            return newId;
        });
    }

    private int getSplitterIndex() {
        return (Integer)this.splitterIndexLazyValue.get();
    }

    public Element getSplitterElement() {
        return this.splitterElement;
    }

    public String getGroupSizeVariableName() {
        return this.getSplitterUniqueId() + "-group-size";
    }

    public String getAggregatorName() {
        return this.getSplitterUniqueId() + "-aggregator";
    }

    public String getAggregatorListenerFlowName() {
        return this.getAggregatorName() + "-listener-flow";
    }

    public String getAggregationCompleteVariableName() {
        return this.getAggregatorName() + "-complete-aggregation";
    }

    public String getAggregationCompleteExpression() {
        return "#[vars.'" + this.getAggregationCompleteVariableName() + "' == false]";
    }

    public String getAggregationVariableName() {
        return this.getAggregatorName() + "-aggregation";
    }

    public String getVmQueueName() {
        return this.getSplitterUniqueId() + "-vm-queue";
    }

    public String getVmConfigName() {
        return "splitter-aggregator-vm-config" + this.getDocumentUniqueId();
    }

    private int getDocumentUniqueId() {
        return (Integer)this.documentIdLazyValue.get();
    }

    private String getSplitterUniqueId() {
        return this.splitterElement.getName() + this.getSplitterIndex();
    }
}

